/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.ThriftConversion;
import org.apache.cassandra.transport.SimpleClient;
import org.apache.cassandra.transport.messages.ResultMessage;

public abstract class CQLOperation
extends Operation {
    public CQLOperation(Session client, int idx) {
        super(client, idx);
    }

    protected abstract void run(Operation.CQLQueryExecutor var1) throws IOException;

    protected abstract boolean validateThriftResult(CqlResult var1);

    protected abstract boolean validateNativeResult(ResultMessage var1);

    @Override
    public void run(final CassandraClient client) throws IOException {
        this.run(new Operation.CQLQueryExecutor(){

            @Override
            public boolean execute(String cqlQuery, List<String> queryParams) throws Exception {
                CqlResult result = null;
                if (CQLOperation.this.session.usePreparedStatements()) {
                    Integer stmntId = CQLOperation.this.getPreparedStatement(client, cqlQuery);
                    result = ((CQLOperation)CQLOperation.this).session.cqlVersion.startsWith("3") ? client.execute_prepared_cql3_query(stmntId, CQLOperation.this.queryParamsAsByteBuffer(queryParams), CQLOperation.this.session.getConsistencyLevel()) : client.execute_prepared_cql_query(stmntId, CQLOperation.this.queryParamsAsByteBuffer(queryParams));
                } else {
                    String formattedQuery = CQLOperation.formatCqlQuery(cqlQuery, queryParams);
                    result = ((CQLOperation)CQLOperation.this).session.cqlVersion.startsWith("3") ? client.execute_cql3_query(ByteBuffer.wrap(formattedQuery.getBytes()), Compression.NONE, CQLOperation.this.session.getConsistencyLevel()) : client.execute_cql_query(ByteBuffer.wrap(formattedQuery.getBytes()), Compression.NONE);
                }
                return CQLOperation.this.validateThriftResult(result);
            }
        });
    }

    @Override
    public void run(final SimpleClient client) throws IOException {
        this.run(new Operation.CQLQueryExecutor(){

            @Override
            public boolean execute(String cqlQuery, List<String> queryParams) throws Exception {
                ResultMessage result = null;
                if (CQLOperation.this.session.usePreparedStatements()) {
                    byte[] stmntId = CQLOperation.getPreparedStatement(client, cqlQuery);
                    result = client.executePrepared(stmntId, CQLOperation.this.queryParamsAsByteBuffer(queryParams), ThriftConversion.fromThrift((ConsistencyLevel)CQLOperation.this.session.getConsistencyLevel()));
                } else {
                    String formattedQuery = CQLOperation.formatCqlQuery(cqlQuery, queryParams);
                    result = client.execute(formattedQuery, ThriftConversion.fromThrift((ConsistencyLevel)CQLOperation.this.session.getConsistencyLevel()));
                }
                return CQLOperation.this.validateNativeResult(result);
            }
        });
    }
}

