/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CounterAdder
extends Operation {
    public CounterAdder(Session client, int index) {
        super(client, index);
    }

    @Override
    public void run(CassandraClient client) throws IOException {
        int i;
        ArrayList<CounterColumn> columns = new ArrayList<CounterColumn>();
        ArrayList<CounterSuperColumn> superColumns = new ArrayList<CounterSuperColumn>();
        String format = "%0" + this.session.getTotalKeysLength() + "d";
        for (i = 0; i < this.session.getColumnsPerKey(); ++i) {
            String columnName = "C" + Integer.toString(i);
            columns.add(new CounterColumn(ByteBufferUtil.bytes((String)columnName), 1L));
        }
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            for (i = 0; i < this.session.getSuperColumns(); ++i) {
                String superColumnName = "S" + Integer.toString(i);
                superColumns.add(new CounterSuperColumn(ByteBuffer.wrap(superColumnName.getBytes()), columns));
            }
        }
        String rawKey = String.format(format, this.index);
        HashMap<ByteBuffer, Map<String, List<Mutation>>> record = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
        record.put(ByteBufferUtil.bytes((String)rawKey), this.session.getColumnFamilyType() == ColumnFamilyType.Super ? this.getSuperColumnsMutationMap(superColumns) : this.getColumnsMutationMap(columns));
        TimerContext context = this.session.latency.time();
        boolean success = false;
        String exceptionMessage = null;
        for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
            try {
                client.batch_mutate(record, this.session.getConsistencyLevel());
                success = true;
                continue;
            }
            catch (Exception e) {
                exceptionMessage = this.getExceptionMessage(e);
                success = false;
            }
        }
        if (!success) {
            this.error(String.format("Operation [%d] retried %d times - error incrementing key %s %s%n", this.index, this.session.getRetryTimes(), rawKey, exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
        }
        this.session.operations.getAndIncrement();
        this.session.keys.getAndIncrement();
        context.stop();
    }

    private Map<String, List<Mutation>> getSuperColumnsMutationMap(List<CounterSuperColumn> superColumns) {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        HashMap<String, List<Mutation>> mutationMap = new HashMap<String, List<Mutation>>();
        for (CounterSuperColumn s : superColumns) {
            ColumnOrSuperColumn cosc = new ColumnOrSuperColumn().setCounter_super_column(s);
            mutations.add(new Mutation().setColumn_or_supercolumn(cosc));
        }
        mutationMap.put("SuperCounter1", mutations);
        return mutationMap;
    }

    private Map<String, List<Mutation>> getColumnsMutationMap(List<CounterColumn> columns) {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        HashMap<String, List<Mutation>> mutationMap = new HashMap<String, List<Mutation>>();
        for (CounterColumn c : columns) {
            ColumnOrSuperColumn cosc = new ColumnOrSuperColumn().setCounter_column(c);
            mutations.add(new Mutation().setColumn_or_supercolumn(cosc));
        }
        mutationMap.put("Counter1", mutations);
        return mutationMap;
    }
}

