/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.operations.CQLOperation;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.transport.messages.ResultMessage;

public class CqlReader
extends CQLOperation {
    private static String cqlQuery = null;

    public CqlReader(Session client, int idx) {
        super(client, idx);
    }

    @Override
    protected void run(Operation.CQLQueryExecutor executor) throws IOException {
        int i;
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            throw new RuntimeException("Super columns are not implemented for CQL");
        }
        if (cqlQuery == null) {
            StringBuilder query = new StringBuilder("SELECT ");
            if (this.session.columnNames == null) {
                if (this.session.cqlVersion.startsWith("2")) {
                    query.append("FIRST ").append(this.session.getColumnsPerKey()).append(" ''..''");
                } else {
                    query.append("*");
                }
            } else {
                for (i = 0; i < this.session.columnNames.size(); ++i) {
                    if (i > 0) {
                        query.append(",");
                    }
                    query.append('?');
                }
            }
            query.append(" FROM ").append(this.wrapInQuotesIfRequired("Standard1"));
            if (this.session.cqlVersion.startsWith("2")) {
                query.append(" USING CONSISTENCY ").append(this.session.getConsistencyLevel().toString());
            }
            query.append(" WHERE KEY=?");
            cqlQuery = query.toString();
        }
        ArrayList<String> queryParams = new ArrayList<String>();
        if (this.session.columnNames != null) {
            for (i = 0; i < this.session.columnNames.size(); ++i) {
                queryParams.add(this.getUnQuotedCqlBlob(this.session.columnNames.get(i).array(), this.session.cqlVersion.startsWith("3")));
            }
        }
        byte[] key = this.generateKey();
        queryParams.add(this.getUnQuotedCqlBlob(key, this.session.cqlVersion.startsWith("3")));
        TimerContext context = this.session.latency.time();
        boolean success = false;
        String exceptionMessage = null;
        for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
            try {
                success = executor.execute(cqlQuery, queryParams);
                continue;
            }
            catch (Exception e) {
                exceptionMessage = this.getExceptionMessage(e);
                success = false;
            }
        }
        if (!success) {
            this.error(String.format("Operation [%d] retried %d times - error reading key %s %s%n with query %s", this.index, this.session.getRetryTimes(), new String(key), exceptionMessage == null ? "" : "(" + exceptionMessage + ")", cqlQuery));
        }
        this.session.operations.getAndIncrement();
        this.session.keys.getAndIncrement();
        context.stop();
    }

    @Override
    protected boolean validateThriftResult(CqlResult result) {
        return ((CqlRow)result.rows.get((int)0)).columns.size() != 0;
    }

    @Override
    protected boolean validateNativeResult(ResultMessage result) {
        return result instanceof ResultMessage.Rows && ((ResultMessage.Rows)result).result.size() != 0;
    }
}

