/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.primitives.Longs;
import java.util.ArrayList;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSummaryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(IndexSummaryBuilder.class);
    private final ArrayList<Long> positions;
    private final ArrayList<byte[]> keys;
    private long keysWritten = 0L;

    public IndexSummaryBuilder(long expectedKeys) {
        long expectedEntries = expectedKeys / (long)DatabaseDescriptor.getIndexInterval().intValue();
        if (expectedEntries > Integer.MAX_VALUE) {
            int effectiveInterval = (int)Math.ceil(2.147483647E9 / (double)expectedKeys);
            expectedEntries = expectedKeys / (long)effectiveInterval;
            assert (expectedEntries <= Integer.MAX_VALUE) : expectedEntries;
            logger.warn("Index interval of {} is too low for {} expected keys; using interval of {} instead", new Object[]{DatabaseDescriptor.getIndexInterval(), expectedKeys, effectiveInterval});
        }
        this.positions = new ArrayList((int)expectedEntries);
        this.keys = new ArrayList((int)expectedEntries);
    }

    public IndexSummaryBuilder maybeAddEntry(DecoratedKey decoratedKey, long indexPosition) {
        if (this.keysWritten % (long)DatabaseDescriptor.getIndexInterval().intValue() == 0L) {
            this.keys.add(ByteBufferUtil.getArray(decoratedKey.key));
            this.positions.add(indexPosition);
        }
        ++this.keysWritten;
        return this;
    }

    public IndexSummary build(IPartitioner partitioner) {
        byte[][] keysArray = new byte[this.keys.size()][];
        for (int i = 0; i < this.keys.size(); ++i) {
            keysArray[i] = this.keys.get(i);
        }
        return new IndexSummary(partitioner, keysArray, Longs.toArray(this.positions));
    }
}

