/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.utils.ByteBufferUtil;

public class MultiGetter
extends Operation {
    public MultiGetter(Session client, int index) {
        super(client, index);
    }

    @Override
    public void run(CassandraClient client) throws IOException {
        SlicePredicate predicate = new SlicePredicate().setSlice_range(new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, this.session.getColumnsPerKey()));
        int offset = this.index * this.session.getKeysPerThread();
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            List<ByteBuffer> keys = this.generateKeys(offset, offset + this.session.getKeysPerCall());
            for (int j = 0; j < this.session.getSuperColumns(); ++j) {
                ColumnParent parent = new ColumnParent("Super1").setSuper_column(ByteBufferUtil.bytes((String)("S" + j)));
                TimerContext context = this.session.latency.time();
                boolean success = false;
                String exceptionMessage = null;
                for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
                    try {
                        Map results = client.multiget_slice(keys, parent, predicate, this.session.getConsistencyLevel());
                        success = results.size() != 0;
                        continue;
                    }
                    catch (Exception e) {
                        exceptionMessage = this.getExceptionMessage(e);
                    }
                }
                if (!success) {
                    this.error(String.format("Operation [%d] retried %d times - error on calling multiget_slice for keys %s %s%n", this.index, this.session.getRetryTimes(), keys, exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
                }
                this.session.operations.getAndIncrement();
                this.session.keys.getAndAdd(keys.size());
                context.stop();
                offset += this.session.getKeysPerCall();
            }
        } else {
            ColumnParent parent = new ColumnParent("Standard1");
            List<ByteBuffer> keys = this.generateKeys(offset, offset + this.session.getKeysPerCall());
            TimerContext context = this.session.latency.time();
            boolean success = false;
            String exceptionMessage = null;
            for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
                try {
                    Map results = client.multiget_slice(keys, parent, predicate, this.session.getConsistencyLevel());
                    success = results.size() != 0;
                    continue;
                }
                catch (Exception e) {
                    exceptionMessage = this.getExceptionMessage(e);
                    success = false;
                }
            }
            if (!success) {
                this.error(String.format("Operation [%d] retried %d times - error on calling multiget_slice for keys %s %s%n", this.index, this.session.getRetryTimes(), keys, exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
            }
            this.session.operations.getAndIncrement();
            this.session.keys.getAndAdd(keys.size());
            context.stop();
            offset += this.session.getKeysPerCall();
        }
    }

    private List<ByteBuffer> generateKeys(int start, int limit) {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        for (int i = start; i < limit; ++i) {
            keys.add(ByteBuffer.wrap(this.generateKey()));
        }
        return keys;
    }
}

