/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class StreamingMetrics {
    public static final String TYPE_NAME = "Streaming";
    private static final ConcurrentMap<InetAddress, StreamingMetrics> instances = new NonBlockingHashMap();
    public static final Counter activeStreamsOutbound = Metrics.newCounter((MetricName)DefaultNameFactory.createMetricName("Streaming", "ActiveOutboundStreams", null));
    public static final Counter totalIncomingBytes = Metrics.newCounter((MetricName)DefaultNameFactory.createMetricName("Streaming", "TotalIncomingBytes", null));
    public static final Counter totalOutgoingBytes = Metrics.newCounter((MetricName)DefaultNameFactory.createMetricName("Streaming", "TotalOutgoingBytes", null));
    public final Counter incomingBytes;
    public final Counter outgoingBytes;

    public static StreamingMetrics get(InetAddress ip) {
        StreamingMetrics metrics = (StreamingMetrics)instances.get(ip);
        if (metrics == null) {
            metrics = new StreamingMetrics(ip);
            instances.put(ip, metrics);
        }
        return metrics;
    }

    public StreamingMetrics(InetAddress peer) {
        DefaultNameFactory factory = new DefaultNameFactory(TYPE_NAME, peer.getHostAddress().replaceAll(":", "."));
        this.incomingBytes = Metrics.newCounter((MetricName)factory.createMetricName("IncomingBytes"));
        this.outgoingBytes = Metrics.newCounter((MetricName)factory.createMetricName("OutgoingBytes"));
    }
}

