/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.AbstractStreamSession;
import org.apache.cassandra.streaming.IStreamCallback;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamHeader;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamOutSession
extends AbstractStreamSession {
    private static final Logger logger = LoggerFactory.getLogger(StreamOutSession.class);
    private static final ConcurrentMap<UUID, StreamOutSession> streams = new NonBlockingHashMap();
    private final Map<String, PendingFile> files = new NonBlockingHashMap();
    private volatile String currentFile;

    public static StreamOutSession create(String table, InetAddress host, IStreamCallback callback) {
        return StreamOutSession.create(table, host, UUIDGen.getTimeUUID(), callback);
    }

    public static StreamOutSession create(String table, InetAddress host, UUID sessionId) {
        return StreamOutSession.create(table, host, sessionId, null);
    }

    public static StreamOutSession create(String table, InetAddress host, UUID sessionId, IStreamCallback callback) {
        StreamOutSession session = new StreamOutSession(table, host, sessionId, callback);
        streams.put(sessionId, session);
        return session;
    }

    public static StreamOutSession get(UUID sessionId) {
        return (StreamOutSession)streams.get(sessionId);
    }

    private StreamOutSession(String table, InetAddress host, UUID sessionId, IStreamCallback callback) {
        super(table, host, sessionId, callback);
    }

    public void addFilesToStream(List<PendingFile> pendingFiles) {
        for (PendingFile pendingFile : pendingFiles) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding file {} to be streamed.", (Object)pendingFile.getFilename());
            }
            this.files.put(pendingFile.getFilename(), pendingFile);
        }
    }

    public void retry() {
        this.streamFile(this.files.get(this.currentFile));
    }

    private void streamFile(PendingFile pf) {
        if (logger.isDebugEnabled()) {
            logger.debug("Streaming {} ...", (Object)pf);
        }
        this.currentFile = pf.getFilename();
        MessagingService.instance().stream(new StreamHeader(this.table, this.getSessionId(), pf), this.getHost());
    }

    public void startNext() {
        assert (this.files.containsKey(this.currentFile));
        this.files.get((Object)this.currentFile).sstable.releaseReference();
        this.files.remove(this.currentFile);
        Iterator<PendingFile> iter = this.files.values().iterator();
        if (iter.hasNext()) {
            this.streamFile(iter.next());
        }
    }

    @Override
    protected void closeInternal(boolean success) {
        for (PendingFile file : this.files.values()) {
            file.sstable.releaseReference();
        }
        streams.remove(this.sessionId);
    }

    void await() throws InterruptedException {
        while (streams.containsKey(this.sessionId)) {
            Thread.sleep(10L);
        }
    }

    public Collection<PendingFile> getFiles() {
        return this.files.values();
    }

    public static Set<InetAddress> getDestinations() {
        HashSet<InetAddress> hosts = new HashSet<InetAddress>();
        for (StreamOutSession session : streams.values()) {
            hosts.add(session.getHost());
        }
        return hosts;
    }

    public static List<PendingFile> getOutgoingFiles(InetAddress host) {
        ArrayList<PendingFile> list = new ArrayList<PendingFile>();
        for (Map.Entry entry : streams.entrySet()) {
            StreamOutSession session = (StreamOutSession)entry.getValue();
            if (!session.getHost().equals(host)) continue;
            list.addAll(session.getFiles());
        }
        return list;
    }

    public void validateCurrentFile(String file) {
        if (!file.equals(this.currentFile)) {
            throw new IllegalStateException(String.format("target reports current file is %s but is %s", file, this.currentFile));
        }
    }

    public void begin() {
        Gossiper.instance.register(this);
        FailureDetector.instance.registerFailureDetectionEventListener(this);
        PendingFile first = this.files.isEmpty() ? null : this.files.values().iterator().next();
        this.currentFile = first == null ? null : first.getFilename();
        StreamHeader header = new StreamHeader(this.table, this.getSessionId(), first, this.files.values());
        logger.info("Streaming to {}", (Object)this.getHost());
        logger.debug("Files are {}", (Object)StringUtils.join(this.files.values(), (String)","));
        MessagingService.instance().stream(header, this.getHost());
    }
}

