/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.MergeIterator;

public class CompactionIterable
extends AbstractCompactionIterable {
    private long row = 0L;
    private static final Comparator<OnDiskAtomIterator> comparator = new Comparator<OnDiskAtomIterator>(){

        @Override
        public int compare(OnDiskAtomIterator i1, OnDiskAtomIterator i2) {
            return i1.getKey().compareTo(i2.getKey());
        }
    };

    public CompactionIterable(OperationType type, List<ICompactionScanner> scanners, CompactionController controller) {
        super(controller, type, scanners);
    }

    @Override
    public CloseableIterator<AbstractCompactedRow> iterator() {
        return MergeIterator.get(this.scanners, comparator, new Reducer());
    }

    public String toString() {
        return this.getCompactionInfo().toString();
    }

    protected class Reducer
    extends MergeIterator.Reducer<OnDiskAtomIterator, AbstractCompactedRow> {
        protected final List<SSTableIdentityIterator> rows = new ArrayList<SSTableIdentityIterator>();

        protected Reducer() {
        }

        @Override
        public void reduce(OnDiskAtomIterator current) {
            this.rows.add((SSTableIdentityIterator)current);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractCompactedRow getReduced() {
            assert (!this.rows.isEmpty());
            CompactionIterable.this.updateCounterFor(this.rows.size());
            try {
                AbstractCompactedRow abstractCompactedRow = CompactionIterable.this.controller.getCompactedRow(new ArrayList<SSTableIdentityIterator>(this.rows));
                return abstractCompactedRow;
            }
            finally {
                this.rows.clear();
                if (CompactionIterable.this.row++ % 1000L == 0L) {
                    long n = 0L;
                    for (ICompactionScanner scanner : CompactionIterable.this.scanners) {
                        n += scanner.getCurrentPosition();
                    }
                    CompactionIterable.this.bytesRead = n;
                    CompactionIterable.this.controller.mayThrottle(CompactionIterable.this.bytesRead);
                }
            }
        }
    }
}

