/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.columniterator.ISSTableColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.columniterator.SSTableNamesIterator;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;

public class NamesQueryFilter
implements IDiskAtomFilter {
    public static final Serializer serializer = new Serializer();
    public final SortedSet<ByteBuffer> columns;
    private final boolean countCQL3Rows;

    public NamesQueryFilter(SortedSet<ByteBuffer> columns) {
        this(columns, false);
    }

    public NamesQueryFilter(SortedSet<ByteBuffer> columns, boolean countCQL3Rows) {
        this.columns = columns;
        this.countCQL3Rows = countCQL3Rows;
    }

    public NamesQueryFilter(ByteBuffer column) {
        this(FBUtilities.singleton(column));
    }

    public NamesQueryFilter withUpdatedColumns(SortedSet<ByteBuffer> newColumns) {
        return new NamesQueryFilter(newColumns, this.countCQL3Rows);
    }

    @Override
    public OnDiskAtomIterator getMemtableColumnIterator(ColumnFamily cf, DecoratedKey key) {
        return Memtable.getNamesIterator(key, cf, this);
    }

    @Override
    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return new SSTableNamesIterator(sstable, key, this.columns);
    }

    @Override
    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        return new SSTableNamesIterator(sstable, file, key, this.columns, indexEntry);
    }

    @Override
    public SuperColumn filterSuperColumn(SuperColumn superColumn, int gcBefore) {
        for (IColumn column : superColumn.getSubColumns()) {
            if (this.columns.contains(column.name()) && QueryFilter.isRelevant(column, superColumn, gcBefore)) continue;
            superColumn.remove(column.name());
        }
        return superColumn;
    }

    @Override
    public void collectReducedColumns(IColumnContainer container, Iterator<IColumn> reducedColumns, int gcBefore) {
        while (reducedColumns.hasNext()) {
            IColumn column = reducedColumns.next();
            if (!QueryFilter.isRelevant(column, container, gcBefore)) continue;
            container.addColumn(column);
        }
    }

    @Override
    public Comparator<IColumn> getColumnComparator(AbstractType<?> comparator) {
        return comparator.columnComparator;
    }

    public String toString() {
        return "NamesQueryFilter(columns=" + StringUtils.join(this.columns, (String)",") + ')';
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public void updateColumnsLimit(int newLimit) {
    }

    @Override
    public int getLiveCount(ColumnFamily cf) {
        if (this.countCQL3Rows) {
            return cf.hasOnlyTombstones() ? 0 : 1;
        }
        int count = 0;
        for (IColumn column : cf) {
            if (!column.isLive()) continue;
            ++count;
        }
        return count;
    }

    public static class Serializer
    implements IVersionedSerializer<NamesQueryFilter> {
        @Override
        public void serialize(NamesQueryFilter f, DataOutput dos, int version) throws IOException {
            dos.writeInt(f.columns.size());
            for (ByteBuffer cName : f.columns) {
                ByteBufferUtil.writeWithShortLength(cName, dos);
            }
            if (version >= 6) {
                dos.writeBoolean(f.countCQL3Rows);
            }
        }

        @Override
        public NamesQueryFilter deserialize(DataInput dis, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        public NamesQueryFilter deserialize(DataInput dis, int version, AbstractType comparator) throws IOException {
            int size = dis.readInt();
            TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(comparator);
            for (int i = 0; i < size; ++i) {
                columns.add(ByteBufferUtil.readWithShortLength(dis));
            }
            boolean countCQL3Rows = version >= 6 ? dis.readBoolean() : false;
            return new NamesQueryFilter(columns, countCQL3Rows);
        }

        @Override
        public long serializedSize(NamesQueryFilter f, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = sizes.sizeof(f.columns.size());
            for (ByteBuffer cName : f.columns) {
                int cNameSize = cName.remaining();
                size += sizes.sizeof((short)cNameSize) + cNameSize;
            }
            if (version >= 6) {
                size += sizes.sizeof(f.countCQL3Rows);
            }
            return size;
        }
    }
}

