/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.JdbcDecimal;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DecimalType
extends AbstractType<BigDecimal> {
    public static final DecimalType instance = new DecimalType();

    DecimalType() {
    }

    @Override
    public int compare(ByteBuffer bb0, ByteBuffer bb1) {
        if (bb0.remaining() == 0) {
            return bb1.remaining() == 0 ? 0 : -1;
        }
        if (bb1.remaining() == 0) {
            return 1;
        }
        return this.compose(bb0).compareTo(this.compose(bb1));
    }

    @Override
    public BigDecimal compose(ByteBuffer bytes) {
        return JdbcDecimal.instance.compose(bytes);
    }

    @Override
    public ByteBuffer decompose(BigDecimal value) {
        return JdbcDecimal.instance.decompose(value);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return JdbcDecimal.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        BigDecimal decimal;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            decimal = new BigDecimal(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make BigDecimal from '%s'", source), e);
        }
        return this.decompose(decimal);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DECIMAL;
    }
}

