/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.streaming.StreamOut;
import org.apache.cassandra.streaming.StreamOutSession;
import org.apache.cassandra.streaming.StreamRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRequestVerbHandler
implements IVerbHandler {
    private static Logger logger = LoggerFactory.getLogger(StreamRequestVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received a StreamRequestMessage from {}", (Object)message.getFrom());
        }
        byte[] body = message.getMessageBody();
        ByteArrayInputStream bufIn = new ByteArrayInputStream(body);
        try {
            StreamRequestMessage srm = StreamRequestMessage.serializer().deserialize(new DataInputStream(bufIn), message.getVersion());
            if (logger.isDebugEnabled()) {
                logger.debug(srm.toString());
            }
            StreamOutSession session = StreamOutSession.create(srm.table, message.getFrom(), srm.sessionId);
            StreamOut.transferRangesForRequest(session, srm.ranges, srm.type);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }
}

