/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.cassandra.db.AbstractColumnContainer;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.ThreadSafeSortedColumns;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollationController {
    private static Logger logger = LoggerFactory.getLogger(CollationController.class);
    private final ColumnFamilyStore cfs;
    private final boolean mutableColumns;
    private final QueryFilter filter;
    private final int gcBefore;
    private int sstablesIterated = 0;

    public CollationController(ColumnFamilyStore cfs, boolean mutableColumns, QueryFilter filter, int gcBefore) {
        this.cfs = cfs;
        this.mutableColumns = mutableColumns;
        this.filter = filter;
        this.gcBefore = gcBefore;
    }

    public ColumnFamily getTopLevelColumns() {
        return this.filter.filter instanceof NamesQueryFilter && this.cfs.metadata.getDefaultValidator() != CounterColumnType.instance ? this.collectTimeOrderedData() : this.collectAllData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily collectTimeOrderedData() {
        logger.debug("collectTimeOrderedData");
        ISortedColumns.Factory factory = this.mutableColumns ? ThreadSafeSortedColumns.factory() : TreeMapBackedSortedColumns.factory();
        ColumnFamily container = ColumnFamily.create(this.cfs.metadata, factory, this.filter.filter.isReversed());
        ArrayList<IColumnIterator> iterators = new ArrayList<IColumnIterator>();
        ColumnFamilyStore.ViewFragment view = this.cfs.markReferenced(this.filter.key);
        try {
            for (Memtable memtable : view.memtables) {
                IColumnIterator iter = this.filter.getMemtableColumnIterator(memtable, this.cfs.metadata.comparator);
                if (iter == null) continue;
                iterators.add(iter);
                container.delete(iter.getColumnFamily());
                while (iter.hasNext()) {
                    container.addColumn((IColumn)iter.next());
                }
            }
            TreeSet<ByteBuffer> filterColumns = new TreeSet<ByteBuffer>(this.cfs.metadata.comparator);
            filterColumns.addAll(((NamesQueryFilter)this.filter.filter).columns);
            QueryFilter reducedFilter = new QueryFilter(this.filter.key, this.filter.path, new NamesQueryFilter(filterColumns));
            Collections.sort(view.sstables, SSTable.maxTimestampComparator);
            for (SSTableReader sstable : view.sstables) {
                long currentMaxTs = sstable.getMaxTimestamp();
                this.reduceNameFilter(reducedFilter, container, currentMaxTs);
                if (((NamesQueryFilter)reducedFilter.filter).columns.isEmpty()) break;
                IColumnIterator iter = reducedFilter.getSSTableColumnIterator(sstable);
                iterators.add(iter);
                if (iter.getColumnFamily() == null) continue;
                container.delete(iter.getColumnFamily());
                ++this.sstablesIterated;
                while (iter.hasNext()) {
                    container.addColumn((IColumn)iter.next());
                }
            }
            if (iterators.isEmpty()) {
                Iterator<SSTableReader> i$ = null;
                return i$;
            }
            final ColumnFamily c2 = container;
            SimpleAbstractColumnIterator toCollate = new SimpleAbstractColumnIterator(){
                final Iterator<IColumn> iter;
                {
                    this.iter = c2.iterator();
                }

                protected IColumn computeNext() {
                    return this.iter.hasNext() ? this.iter.next() : (IColumn)this.endOfData();
                }

                @Override
                public ColumnFamily getColumnFamily() {
                    return c2;
                }

                @Override
                public DecoratedKey getKey() {
                    return ((CollationController)CollationController.this).filter.key;
                }
            };
            ColumnFamily returnCF = container.cloneMeShallow();
            this.filter.collateColumns(returnCF, Collections.singletonList(toCollate), this.cfs.metadata.comparator, this.gcBefore);
            ColumnFamily columnFamily = returnCF;
            return columnFamily;
        }
        finally {
            for (IColumnIterator iter : iterators) {
                FileUtils.closeQuietly(iter);
            }
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    private void reduceNameFilter(QueryFilter filter, ColumnFamily returnCF, long sstableTimestamp) {
        ColumnFamily container;
        AbstractColumnContainer abstractColumnContainer = container = filter.path.superColumnName != null ? (SuperColumn)returnCF.getColumn(filter.path.superColumnName) : returnCF;
        if (container == null) {
            return;
        }
        Iterator iterator = ((NamesQueryFilter)filter.filter).columns.iterator();
        while (iterator.hasNext()) {
            ByteBuffer filterColumn = (ByteBuffer)iterator.next();
            IColumn column = container.getColumn(filterColumn);
            if (column == null || column.minTimestamp() <= sstableTimestamp) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily collectAllData() {
        logger.debug("collectAllData");
        ISortedColumns.Factory factory = this.mutableColumns ? ThreadSafeSortedColumns.factory() : ArrayBackedSortedColumns.factory();
        ArrayList<IColumnIterator> iterators = new ArrayList<IColumnIterator>();
        ColumnFamily returnCF = ColumnFamily.create(this.cfs.metadata, factory, this.filter.filter.isReversed());
        ColumnFamilyStore.ViewFragment view = this.cfs.markReferenced(this.filter.key);
        try {
            ColumnFamily columnFamily;
            IColumnIterator iter;
            for (Memtable memtable : view.memtables) {
                iter = this.filter.getMemtableColumnIterator(memtable, this.cfs.metadata.comparator);
                if (iter == null) continue;
                returnCF.delete(iter.getColumnFamily());
                iterators.add(iter);
            }
            for (SSTableReader sstable : view.sstables) {
                iter = this.filter.getSSTableColumnIterator(sstable);
                iterators.add(iter);
                if (iter.getColumnFamily() == null) continue;
                returnCF.delete(iter.getColumnFamily());
                ++this.sstablesIterated;
            }
            if (iterators.isEmpty()) {
                columnFamily = null;
                return columnFamily;
            }
            this.filter.collateColumns(returnCF, iterators, this.cfs.metadata.comparator, this.gcBefore);
            columnFamily = returnCF;
            return columnFamily;
        }
        finally {
            for (IColumnIterator iter : iterators) {
                FileUtils.closeQuietly(iter);
            }
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    public int getSstablesIterated() {
        return this.sstablesIterated;
    }
}

