/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.CounterUpdateColumn;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnSerializer
implements IColumnSerializer {
    private static final Logger logger = LoggerFactory.getLogger(ColumnSerializer.class);
    public static final int DELETION_MASK = 1;
    public static final int EXPIRATION_MASK = 2;
    public static final int COUNTER_MASK = 4;
    public static final int COUNTER_UPDATE_MASK = 8;

    @Override
    public void serialize(IColumn column, DataOutput dos) {
        assert (column.name().remaining() > 0);
        ByteBufferUtil.writeWithShortLength(column.name(), dos);
        try {
            dos.writeByte(column.serializationFlags());
            if (column instanceof CounterColumn) {
                dos.writeLong(((CounterColumn)column).timestampOfLastDelete());
            } else if (column instanceof ExpiringColumn) {
                dos.writeInt(((ExpiringColumn)column).getTimeToLive());
                dos.writeInt(column.getLocalDeletionTime());
            }
            dos.writeLong(column.timestamp());
            ByteBufferUtil.writeWithLength(column.value(), dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Column deserialize(DataInput dis) throws IOException {
        return this.deserialize(dis, false);
    }

    public Column deserialize(DataInput dis, boolean fromRemote) throws IOException {
        return this.deserialize(dis, fromRemote, (int)(System.currentTimeMillis() / 1000L));
    }

    @Override
    public Column deserialize(DataInput dis, boolean fromRemote, int expireBefore) throws IOException {
        ByteBuffer name = ByteBufferUtil.readWithShortLength(dis);
        if (name.remaining() <= 0) {
            throw new CorruptColumnException("invalid column name length " + name.remaining());
        }
        int b = dis.readUnsignedByte();
        if ((b & 4) != 0) {
            long timestampOfLastDelete = dis.readLong();
            long ts = dis.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(dis);
            return CounterColumn.create(name, value, ts, timestampOfLastDelete, fromRemote);
        }
        if ((b & 2) != 0) {
            int ttl = dis.readInt();
            int expiration = dis.readInt();
            long ts = dis.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(dis);
            return ExpiringColumn.create(name, value, ts, ttl, expiration, expireBefore);
        }
        long ts = dis.readLong();
        ByteBuffer value = ByteBufferUtil.readWithLength(dis);
        return (b & 8) != 0 ? new CounterUpdateColumn(name, value, ts) : ((b & 1) == 0 ? new Column(name, value, ts) : new DeletedColumn(name, value, ts));
    }

    private static class CorruptColumnException
    extends IOException {
        public CorruptColumnException(String s) {
            super(s);
        }
    }
}

