/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.Allocator;

public class TreeMapBackedSortedColumns
extends TreeMap<ByteBuffer, IColumn>
implements ISortedColumns {
    public static final ISortedColumns.Factory factory = new ISortedColumns.Factory(){

        @Override
        public ISortedColumns create(AbstractType<?> comparator, boolean insertReversed) {
            return new TreeMapBackedSortedColumns(comparator);
        }

        @Override
        public ISortedColumns fromSorted(SortedMap<ByteBuffer, IColumn> sortedMap, boolean insertReversed) {
            return new TreeMapBackedSortedColumns(sortedMap);
        }
    };

    public static ISortedColumns.Factory factory() {
        return factory;
    }

    @Override
    public AbstractType<?> getComparator() {
        return (AbstractType)this.comparator();
    }

    private TreeMapBackedSortedColumns(AbstractType<?> comparator) {
        super(comparator);
    }

    private TreeMapBackedSortedColumns(SortedMap<ByteBuffer, IColumn> columns) {
        super(columns);
    }

    @Override
    public ISortedColumns.Factory getFactory() {
        return TreeMapBackedSortedColumns.factory();
    }

    @Override
    public ISortedColumns cloneMe() {
        return new TreeMapBackedSortedColumns(this);
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        ByteBuffer name = column.name();
        IColumn oldColumn = this.put(name, column);
        if (oldColumn != null) {
            if (oldColumn instanceof SuperColumn) {
                assert (column instanceof SuperColumn);
                ((SuperColumn)oldColumn).putColumn((SuperColumn)column, allocator);
            } else {
                IColumn reconciledColumn = column.reconcile(oldColumn, allocator);
                this.put(name, reconciledColumn);
            }
        }
    }

    @Override
    public void addAll(ISortedColumns cm, Allocator allocator) {
        for (IColumn column : cm.getSortedColumns()) {
            this.addColumn(column, allocator);
        }
    }

    @Override
    public boolean replace(IColumn oldColumn, IColumn newColumn) {
        if (!oldColumn.name().equals(newColumn.name())) {
            throw new IllegalArgumentException();
        }
        IColumn previous = this.put(oldColumn.name(), newColumn);
        if (previous == null) {
            this.remove(oldColumn.name());
            return false;
        }
        if (!previous.equals(oldColumn)) {
            this.put(oldColumn.name(), previous);
            return false;
        }
        return true;
    }

    @Override
    public IColumn getColumn(ByteBuffer name) {
        return (IColumn)this.get(name);
    }

    @Override
    public void removeColumn(ByteBuffer name) {
        this.remove(name);
    }

    @Override
    public Collection<IColumn> getSortedColumns() {
        return this.values();
    }

    @Override
    public Collection<IColumn> getReverseSortedColumns() {
        return this.descendingMap().values();
    }

    @Override
    public SortedSet<ByteBuffer> getColumnNames() {
        return this.navigableKeySet();
    }

    @Override
    public int getEstimatedColumnCount() {
        return this.size();
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.values().iterator();
    }

    @Override
    public Iterator<IColumn> reverseIterator() {
        return this.getReverseSortedColumns().iterator();
    }
}

