/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public class BufferedSegmentedFile
extends SegmentedFile {
    public BufferedSegmentedFile(String path, long length) {
        super(path, length);
    }

    @Override
    public FileDataInput getSegment(long position) {
        try {
            RandomAccessReader file = RandomAccessReader.open(new File(this.path));
            file.seek(position);
            return file;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void cleanup() {
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path) {
            long length = new File(path).length();
            return new BufferedSegmentedFile(path, length);
        }
    }
}

