/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.FrameCompressor;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class Frame {
    public final Header header;
    public final ChannelBuffer body;
    public final Connection connection;

    private Frame(Header header, ChannelBuffer body, Connection connection) {
        this.header = header;
        this.body = body;
        this.connection = connection;
    }

    public static Frame create(ChannelBuffer fullFrame, Connection connection) {
        assert (fullFrame.readableBytes() >= 8) : String.format("Frame too short (%d bytes = %s)", fullFrame.readableBytes(), ByteBufferUtil.bytesToHex(fullFrame.toByteBuffer()));
        int version = fullFrame.readByte();
        byte flags = fullFrame.readByte();
        byte streamId = fullFrame.readByte();
        byte opcode = fullFrame.readByte();
        int length = fullFrame.readInt();
        assert (length == fullFrame.readableBytes());
        Message.Direction direction = Message.Direction.extractFromVersion(version);
        Header header = new Header(version &= 0x7F, flags, (int)streamId, Message.Type.fromOpcode(opcode, direction));
        return new Frame(header, fullFrame, connection);
    }

    public static Frame create(Message.Type type, int streamId, EnumSet<Header.Flag> flags, ChannelBuffer body, Connection connection) {
        Header header = new Header(1, flags, streamId, type);
        return new Frame(header, body, connection);
    }

    public Frame with(ChannelBuffer newBody) {
        return new Frame(this.header, newBody, this.connection);
    }

    public static class Compressor
    extends OneToOneEncoder {
        public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            if (frame.header.type == Message.Type.STARTUP || frame.connection == null) {
                return frame;
            }
            FrameCompressor compressor = frame.connection.getCompressor();
            if (compressor == null) {
                return frame;
            }
            frame.header.flags.add(Header.Flag.COMPRESSED);
            return compressor.compress(frame);
        }
    }

    public static class Decompressor
    extends OneToOneDecoder {
        public Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            if (!frame.header.flags.contains((Object)Header.Flag.COMPRESSED)) {
                return frame;
            }
            FrameCompressor compressor = frame.connection.getCompressor();
            if (compressor == null) {
                return frame;
            }
            return compressor.decompress(frame);
        }
    }

    public static class Encoder
    extends OneToOneEncoder {
        public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            ChannelBuffer header = ChannelBuffers.buffer((int)8);
            Message.Type type = frame.header.type;
            header.writeByte(type.direction.addToVersion(frame.header.version));
            header.writeByte(Header.Flag.serialize(frame.header.flags));
            header.writeByte(frame.header.streamId);
            header.writeByte(type.opcode);
            header.writeInt(frame.body.readableBytes());
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, frame.body});
        }
    }

    public static class Decoder
    extends LengthFieldBasedFrameDecoder {
        private static final int MAX_FRAME_LENTH = 0x10000000;
        private final Connection connection;

        public Decoder(Connection.Tracker tracker, Connection.Factory factory) {
            super(0x10000000, 4, 4, 0, 0, true);
            this.connection = factory.newConnection(tracker);
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            this.connection.registerChannel(e.getChannel());
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
            try {
                ChannelBuffer frame;
                if (buffer.readableBytes() == 0) {
                    return null;
                }
                byte firstByte = buffer.getByte(0);
                Message.Direction direction = Message.Direction.extractFromVersion(firstByte);
                int version = firstByte & 0x7F;
                if (version != 1) {
                    throw new ProtocolException("Invalid or unsupported protocol version: " + version);
                }
                if (buffer.readableBytes() >= 4) {
                    Message.Type.fromOpcode(buffer.getByte(3), direction);
                }
                if ((frame = (ChannelBuffer)super.decode(ctx, channel, buffer)) == null) {
                    return null;
                }
                return Frame.create(frame, this.connection);
            }
            catch (CorruptedFrameException e) {
                throw new ProtocolException(e.getMessage());
            }
            catch (TooLongFrameException e) {
                throw new ProtocolException(e.getMessage());
            }
        }
    }

    public static class Header {
        public static final int LENGTH = 8;
        public static final int CURRENT_VERSION = 1;
        public final int version;
        public final EnumSet<Flag> flags;
        public final int streamId;
        public final Message.Type type;

        private Header(int version, int flags, int streamId, Message.Type type) {
            this(version, Flag.deserialize(flags), streamId, type);
        }

        private Header(int version, EnumSet<Flag> flags, int streamId, Message.Type type) {
            this.version = version;
            this.flags = flags;
            this.streamId = streamId;
            this.type = type;
        }

        public static enum Flag {
            COMPRESSED,
            TRACING;


            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                Flag[] values = Flag.values();
                for (int n = 0; n < 8; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(values[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }
        }
    }
}

