/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

class SliceFromReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    SliceFromReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand rm, DataOutput dos, int version) throws IOException {
        SliceFromReadCommand realRM = (SliceFromReadCommand)rm;
        dos.writeBoolean(realRM.isDigestQuery());
        dos.writeUTF(realRM.table);
        ByteBufferUtil.writeWithShortLength(realRM.key, dos);
        realRM.queryPath.serialize(dos);
        SliceQueryFilter.serializer.serialize(realRM.filter, dos, version);
    }

    @Override
    public ReadCommand deserialize(DataInput dis, int version) throws IOException {
        boolean isDigest = dis.readBoolean();
        String table = dis.readUTF();
        ByteBuffer key = ByteBufferUtil.readWithShortLength(dis);
        QueryPath path = QueryPath.deserialize(dis);
        SliceQueryFilter filter = SliceQueryFilter.serializer.deserialize(dis, version);
        SliceFromReadCommand rm = new SliceFromReadCommand(table, key, path, filter);
        rm.setDigestQuery(isDigest);
        return rm;
    }

    @Override
    public long serializedSize(ReadCommand cmd, int version) {
        TypeSizes sizes = TypeSizes.NATIVE;
        SliceFromReadCommand command = (SliceFromReadCommand)cmd;
        int keySize = command.key.remaining();
        int size = sizes.sizeof(cmd.isDigestQuery());
        size += sizes.sizeof(command.table);
        size += sizes.sizeof((short)keySize) + keySize;
        size += command.queryPath.serializedSize(sizes);
        size = (int)((long)size + SliceQueryFilter.serializer.serializedSize(command.filter, version));
        return size;
    }
}

