/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.IStreamCallback;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamInSession;
import org.apache.cassandra.streaming.StreamRequest;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamIn {
    private static final Logger logger = LoggerFactory.getLogger(StreamIn.class);

    public static void requestRanges(InetAddress source, String tableName, Collection<Range<Token>> ranges, IStreamCallback callback, OperationType type) {
        StreamIn.requestRanges(source, tableName, Table.open(tableName).getColumnFamilyStores(), ranges, callback, type);
    }

    public static void requestRanges(InetAddress source, String tableName, Collection<ColumnFamilyStore> columnFamilies, Collection<Range<Token>> ranges, IStreamCallback callback, OperationType type) {
        assert (ranges.size() > 0);
        if (logger.isDebugEnabled()) {
            logger.debug("Requesting from {} ranges {}", (Object)source, (Object)StringUtils.join(ranges, (String)", "));
        }
        StreamInSession session = StreamInSession.create(source, callback);
        StreamRequest srm = new StreamRequest(FBUtilities.getBroadcastAddress(), ranges, tableName, columnFamilies, session.getSessionId(), type);
        MessagingService.instance().sendOneWay(srm.createMessage(), source);
    }

    public static PendingFile getContextMapping(PendingFile remote) throws IOException {
        Descriptor remotedesc = remote.desc;
        if (!remotedesc.isStreamCompatible()) {
            throw new UnsupportedOperationException(String.format("SSTable %s is not compatible with current version %s", remote.getFilename(), Descriptor.Version.CURRENT));
        }
        Table table = Table.open(remotedesc.ksname);
        ColumnFamilyStore cfStore = table.getColumnFamilyStore(remotedesc.cfname);
        Directories.DataDirectory localDir = cfStore.directories.getLocationCapableOfSize(remote.size);
        if (localDir == null) {
            throw new RuntimeException("Insufficient disk space to store " + remote.size + " bytes");
        }
        Descriptor localdesc = Descriptor.fromFilename(cfStore.getTempSSTablePath(cfStore.directories.getLocationForDisk(localDir)));
        return new PendingFile(localdesc, remote);
    }
}

