/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.thrift.TriggerDef;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TriggerDefinition {
    private static final String TRIGGER_NAME = "trigger_name";
    private static final String TRIGGER_OPTIONS = "trigger_options";
    private static final String CLASS = "class";
    public final String name;
    public final String classOption;

    TriggerDefinition(String name, String classOption) {
        this.name = name;
        this.classOption = classOption;
    }

    public static TriggerDefinition create(String name, String classOption) {
        return new TriggerDefinition(name, classOption);
    }

    public static List<TriggerDefinition> fromSchema(Row serializedTriggers) {
        ArrayList<TriggerDefinition> triggers = new ArrayList<TriggerDefinition>();
        String query = String.format("SELECT * FROM %s.%s", "system", "schema_triggers");
        for (UntypedResultSet.Row row : QueryProcessor.resultify(query, serializedTriggers)) {
            String name = row.getString(TRIGGER_NAME);
            String classOption = row.getMap(TRIGGER_OPTIONS, UTF8Type.instance, UTF8Type.instance).get(CLASS);
            triggers.add(new TriggerDefinition(name, classOption));
        }
        return triggers;
    }

    public void toSchema(RowMutation rm, String cfName, long timestamp) {
        ColumnFamily cf = rm.addOrGet("schema_triggers");
        ColumnNameBuilder builder = CFMetaData.SchemaTriggersCf.getCfDef().getColumnNameBuilder();
        builder.add(ByteBufferUtil.bytes(cfName)).add(ByteBufferUtil.bytes(this.name));
        cf.addColumn(builder.copy().add(ByteBufferUtil.bytes("")).build(), ByteBufferUtil.bytes(""), timestamp);
        cf.addColumn(builder.copy().add(ByteBufferUtil.bytes(TRIGGER_OPTIONS)).add(ByteBufferUtil.bytes(CLASS)).build(), ByteBufferUtil.bytes(this.classOption), timestamp);
    }

    public void deleteFromSchema(RowMutation rm, String cfName, long timestamp) {
        ColumnFamily cf = rm.addOrGet("schema_triggers");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        ColumnNameBuilder builder = CFMetaData.SchemaTriggersCf.getCfDef().getColumnNameBuilder();
        builder.add(ByteBufferUtil.bytes(cfName)).add(ByteBufferUtil.bytes(this.name));
        cf.addAtom(new RangeTombstone(builder.build(), builder.buildAsEndOfRange(), timestamp, ldt));
    }

    public static TriggerDefinition fromThrift(TriggerDef thriftDef) {
        return new TriggerDefinition(thriftDef.getName(), (String)thriftDef.getOptions().get(CLASS));
    }

    public TriggerDef toThrift() {
        TriggerDef td = new TriggerDef();
        td.setName(this.name);
        td.setOptions(Collections.singletonMap(CLASS, this.classOption));
        return td;
    }

    public static Map<String, TriggerDefinition> fromThrift(List<TriggerDef> thriftDefs) {
        HashMap<String, TriggerDefinition> triggerDefinitions = new HashMap<String, TriggerDefinition>();
        for (TriggerDef thriftDef : thriftDefs) {
            triggerDefinitions.put(thriftDef.getName(), TriggerDefinition.fromThrift(thriftDef));
        }
        return triggerDefinitions;
    }

    public static List<TriggerDef> toThrift(Map<String, TriggerDefinition> triggers) {
        ArrayList<TriggerDef> thriftDefs = new ArrayList<TriggerDef>(triggers.size());
        for (TriggerDefinition def : triggers.values()) {
            thriftDefs.add(def.toThrift());
        }
        return thriftDefs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TriggerDefinition)) {
            return false;
        }
        TriggerDefinition td = (TriggerDefinition)o;
        return Objects.equal((Object)this.name, (Object)td.name) && Objects.equal((Object)this.classOption, (Object)td.classOption);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.classOption});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("classOption", (Object)this.classOption).toString();
    }
}

