/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RawSelector;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.cql3.statements.Selection;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.Pageable;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.github.jamm.MemoryMeter;

public class SelectStatement
implements CQLStatement,
MeasurableForPreparedCache {
    private static final int DEFAULT_COUNT_PAGE_SIZE = 10000;
    private final int boundTerms;
    public final CFDefinition cfDef;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final Restriction[] keyRestrictions;
    private final Restriction[] columnRestrictions;
    private final Map<CFDefinition.Name, Restriction> metadataRestrictions = new HashMap<CFDefinition.Name, Restriction>();
    private final Set<CFDefinition.Name> restrictedNames = new HashSet<CFDefinition.Name>();
    private Restriction.Slice sliceRestriction;
    private boolean isReversed;
    private boolean onToken;
    private boolean isKeyRange;
    private boolean keyIsInRelation;
    private boolean usesSecondaryIndexing;
    private Map<CFDefinition.Name, Integer> orderingIndexes;
    private boolean selectsStaticColumns;
    private boolean selectsOnlyStaticColumns;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), false, false, null, false);
    private static final Predicate<CFDefinition.Name> isStaticFilter = new Predicate<CFDefinition.Name>(){

        public boolean apply(CFDefinition.Name name) {
            return name.kind == CFDefinition.Name.Kind.STATIC;
        }
    };

    public SelectStatement(CFDefinition cfDef, int boundTerms, Parameters parameters, Selection selection, Term limit) {
        this.cfDef = cfDef;
        this.boundTerms = boundTerms;
        this.selection = selection;
        this.keyRestrictions = new Restriction[cfDef.partitionKeyCount()];
        this.columnRestrictions = new Restriction[cfDef.clusteringColumnsCount()];
        this.parameters = parameters;
        this.limit = limit;
        this.initStaticColumnsInfo();
    }

    private void initStaticColumnsInfo() {
        if (!this.cfDef.cfm.hasStaticColumns()) {
            return;
        }
        if (this.selection.isWildcard()) {
            this.selectsStaticColumns = true;
            return;
        }
        this.selectsStaticColumns = !Iterables.isEmpty((Iterable)Iterables.filter(this.selection.getColumnsList(), isStaticFilter));
        this.selectsOnlyStaticColumns = true;
        for (CFDefinition.Name name : this.selection.getColumnsList()) {
            if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS || name.kind == CFDefinition.Name.Kind.STATIC) continue;
            this.selectsOnlyStaticColumns = false;
            break;
        }
    }

    static SelectStatement forSelection(CFDefinition cfDef, Selection selection) {
        return new SelectStatement(cfDef, 0, defaultParameters, selection, null);
    }

    public ResultSet.Metadata getResultMetadata() {
        return this.parameters.isCount ? ResultSet.makeCountMetadata(this.keyspace(), this.columnFamily(), this.parameters.countAlias) : this.selection.getResultMetadata();
    }

    @Override
    public long measureForPreparedCache(MemoryMeter meter) {
        return meter.measure((Object)this) + meter.measureDeep((Object)this.parameters) + meter.measureDeep((Object)this.selection) + (this.limit == null ? 0L : meter.measureDeep((Object)this.limit)) + meter.measureDeep((Object)this.keyRestrictions) + meter.measureDeep((Object)this.columnRestrictions) + meter.measureDeep(this.metadataRestrictions) + meter.measureDeep(this.restrictedNames) + (this.sliceRestriction == null ? 0L : meter.measureDeep((Object)this.sliceRestriction)) + (this.orderingIndexes == null ? 0L : meter.measureDeep(this.orderingIndexes));
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ReadCommand> commands;
        ConsistencyLevel cl = options.getConsistency();
        List<ByteBuffer> variables = options.getValues();
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        cl.validateForRead(this.keyspace());
        int limit = this.getLimit(variables);
        long now = System.currentTimeMillis();
        Pageable command = this.isKeyRange || this.usesSecondaryIndexing ? this.getRangeCommand(variables, limit, now) : ((commands = this.getSliceCommands(variables, limit, now)) == null ? null : new Pageable.ReadCommands(commands));
        int pageSize = options.getPageSize();
        if (this.parameters.isCount && pageSize <= 0 && MessagingService.instance().allNodesAtLeast20) {
            pageSize = 10000;
        }
        if (pageSize <= 0 || command == null || !QueryPagers.mayNeedPaging(command, pageSize)) {
            return this.execute(command, cl, variables, limit, now);
        }
        QueryPager pager = QueryPagers.pager(command, cl, options.getPagingState());
        if (this.parameters.isCount) {
            return this.pageCountQuery(pager, variables, pageSize, now);
        }
        if (this.needsPostQueryOrdering()) {
            throw new InvalidRequestException("Cannot page queries with both ORDER BY and a IN restriction on the partition key; you must either remove the ORDER BY or the IN and sort client side, or disable paging for this query");
        }
        List<Row> page = pager.fetchPage(pageSize);
        ResultMessage.Rows msg = this.processResults(page, variables, limit, now);
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    private ResultMessage.Rows execute(Pageable command, ConsistencyLevel cl, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException, RequestExecutionException {
        List<Row> rows = command == null ? Collections.emptyList() : (command instanceof Pageable.ReadCommands ? StorageProxy.read(((Pageable.ReadCommands)command).commands, cl) : StorageProxy.getRangeSlice((RangeSliceCommand)command, cl));
        return this.processResults(rows, variables, limit, now);
    }

    private ResultMessage.Rows pageCountQuery(QueryPager pager, List<ByteBuffer> variables, int pageSize, long now) throws RequestValidationException, RequestExecutionException {
        int count = 0;
        while (!pager.isExhausted()) {
            int maxLimit = pager.maxRemaining();
            ResultSet rset = this.process(pager.fetchPage(pageSize), variables, maxLimit, now);
            count += rset.rows.size();
        }
        ResultSet result = ResultSet.makeCountResult(this.keyspace(), this.columnFamily(), count, this.parameters.countAlias);
        return new ResultMessage.Rows(result);
    }

    public ResultMessage.Rows processResults(List<Row> rows, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        ResultSet rset = this.process(rows, variables, limit, now);
        rset = this.parameters.isCount ? rset.makeCountResult(this.parameters.countAlias) : rset;
        return new ResultMessage.Rows(rset);
    }

    static List<Row> readLocally(String keyspaceName, List<ReadCommand> cmds) {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        ArrayList<Row> rows = new ArrayList<Row>(cmds.size());
        for (ReadCommand cmd : cmds) {
            rows.add(cmd.getRow(keyspace));
        }
        return rows;
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state) throws RequestExecutionException, RequestValidationException {
        List<ReadCommand> commands;
        RangeSliceCommand command;
        List<ByteBuffer> variables = Collections.emptyList();
        int limit = this.getLimit(variables);
        long now = System.currentTimeMillis();
        List<Object> rows = this.isKeyRange || this.usesSecondaryIndexing ? ((command = this.getRangeCommand(variables, limit, now)) == null ? Collections.emptyList() : command.executeLocally()) : ((commands = this.getSliceCommands(variables, limit, now)) == null ? Collections.emptyList() : SelectStatement.readLocally(this.keyspace(), commands));
        return this.processResults(rows, variables, limit, now);
    }

    public ResultSet process(List<Row> rows) throws InvalidRequestException {
        assert (!this.parameters.isCount);
        return this.process(rows, Collections.emptyList(), this.getLimit(Collections.emptyList()), System.currentTimeMillis());
    }

    public String keyspace() {
        return this.cfDef.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfDef.cfm.cfName;
    }

    private List<ReadCommand> getSliceCommands(List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        Collection<ByteBuffer> keys = this.getKeys(variables);
        if (keys.isEmpty()) {
            return null;
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        IDiskAtomFilter filter = this.makeFilter(variables, limit);
        if (filter == null) {
            return null;
        }
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            commands.add(ReadCommand.create(this.keyspace(), key, this.columnFamily(), now, filter.cloneShallow()));
        }
        return commands;
    }

    private RangeSliceCommand getRangeCommand(List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        IDiskAtomFilter filter = this.makeFilter(variables, limit);
        if (filter == null) {
            return null;
        }
        List<IndexExpression> expressions = this.getIndexExpressions(variables);
        AbstractBounds<RowPosition> keyBounds = this.getKeyBounds(variables);
        return keyBounds == null ? null : new RangeSliceCommand(this.keyspace(), this.columnFamily(), now, filter, keyBounds, expressions, limit, !this.parameters.isDistinct, false);
    }

    private AbstractBounds<RowPosition> getKeyBounds(List<ByteBuffer> variables) throws InvalidRequestException {
        RowPosition finishKey;
        IPartitioner p = StorageService.getPartitioner();
        if (this.onToken) {
            Token startToken = this.getTokenBound(Bound.START, variables, p);
            Token endToken = this.getTokenBound(Bound.END, variables, p);
            boolean includeStart = this.includeKeyBound(Bound.START);
            boolean includeEnd = this.includeKeyBound(Bound.END);
            int cmp = startToken.compareTo(endToken);
            if (!(startToken.isMinimum() || endToken.isMinimum() || cmp <= 0 && (cmp != 0 || includeStart && includeEnd))) {
                return null;
            }
            Token.KeyBound start = includeStart ? startToken.minKeyBound() : startToken.maxKeyBound();
            Token.KeyBound end = includeEnd ? endToken.maxKeyBound() : endToken.minKeyBound();
            return new Range<RowPosition>(start, end);
        }
        ByteBuffer startKeyBytes = this.getKeyBound(Bound.START, variables);
        ByteBuffer finishKeyBytes = this.getKeyBound(Bound.END, variables);
        RowPosition startKey = RowPosition.forKey(startKeyBytes, p);
        if (startKey.compareTo(finishKey = RowPosition.forKey(finishKeyBytes, p)) > 0 && !finishKey.isMinimum(p)) {
            return null;
        }
        if (this.includeKeyBound(Bound.START)) {
            return this.includeKeyBound(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey);
        }
        return this.includeKeyBound(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey);
    }

    private IDiskAtomFilter makeFilter(List<ByteBuffer> variables, int limit) throws InvalidRequestException {
        if (this.parameters.isDistinct) {
            return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, false, 1, -1);
        }
        if (this.isColumnRange()) {
            ColumnSlice[] slices;
            int toGroup = this.cfDef.isCompact ? -1 : this.cfDef.clusteringColumnsCount();
            List<ByteBuffer> startBounds = this.getRequestedBound(Bound.START, variables);
            List<ByteBuffer> endBounds = this.getRequestedBound(Bound.END, variables);
            assert (startBounds.size() == endBounds.size());
            ColumnSlice staticSlice = null;
            if (this.selectsStaticColumns && !this.usesSecondaryIndexing) {
                ColumnNameBuilder staticPrefix = this.cfDef.cfm.getStaticColumnNameBuilder();
                ColumnSlice columnSlice = staticSlice = this.isReversed ? new ColumnSlice(staticPrefix.buildAsEndOfRange(), ByteBufferUtil.EMPTY_BYTE_BUFFER) : new ColumnSlice(ByteBufferUtil.EMPTY_BYTE_BUFFER, staticPrefix.buildAsEndOfRange());
                if (this.selectsOnlyStaticColumns) {
                    return this.sliceFilter(staticSlice, limit, toGroup);
                }
            }
            if (startBounds.size() == 1) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(0), endBounds.get(0));
                if (slice.isAlwaysEmpty(this.cfDef.cfm.comparator, this.isReversed)) {
                    return staticSlice == null ? null : this.sliceFilter(staticSlice, limit, toGroup);
                }
                return staticSlice == null ? this.sliceFilter(slice, limit, toGroup) : (slice.includes(this.cfDef.cfm.comparator, staticSlice.finish) ? this.sliceFilter(new ColumnSlice(staticSlice.start, slice.finish), limit, toGroup) : this.sliceFilter(new ColumnSlice[]{staticSlice, slice}, limit, toGroup));
            }
            ArrayList<ColumnSlice> l = new ArrayList<ColumnSlice>(startBounds.size());
            for (int i = 0; i < startBounds.size(); ++i) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(i), endBounds.get(i));
                if (slice.isAlwaysEmpty(this.cfDef.cfm.comparator, this.isReversed)) continue;
                l.add(slice);
            }
            if (l.isEmpty()) {
                return staticSlice == null ? null : this.sliceFilter(staticSlice, limit, toGroup);
            }
            if (staticSlice == null) {
                return this.sliceFilter(l.toArray(new ColumnSlice[l.size()]), limit, toGroup);
            }
            if (this.isReversed) {
                if (((ColumnSlice)l.get(l.size() - 1)).includes(this.cfDef.cfm.comparator, staticSlice.start)) {
                    slices = l.toArray(new ColumnSlice[l.size()]);
                    slices[slices.length - 1] = new ColumnSlice(slices[slices.length - 1].start, ByteBufferUtil.EMPTY_BYTE_BUFFER);
                } else {
                    slices = l.toArray(new ColumnSlice[l.size() + 1]);
                    slices[slices.length - 1] = staticSlice;
                }
            } else if (((ColumnSlice)l.get(0)).includes(this.cfDef.cfm.comparator, staticSlice.finish)) {
                slices = new ColumnSlice[l.size()];
                slices[0] = new ColumnSlice(ByteBufferUtil.EMPTY_BYTE_BUFFER, ((ColumnSlice)l.get((int)0)).finish);
                for (int i = 1; i < l.size(); ++i) {
                    slices[i] = (ColumnSlice)l.get(i);
                }
            } else {
                slices = new ColumnSlice[l.size() + 1];
                slices[0] = staticSlice;
                for (int i = 0; i < l.size(); ++i) {
                    slices[i + 1] = (ColumnSlice)l.get(i);
                }
            }
            return this.sliceFilter(slices, limit, toGroup);
        }
        SortedSet<ByteBuffer> cellNames = this.getRequestedColumns(variables);
        if (cellNames == null) {
            return null;
        }
        QueryProcessor.validateCellNames(cellNames);
        return new NamesQueryFilter(cellNames, true);
    }

    private SliceQueryFilter sliceFilter(ColumnSlice slice, int limit, int toGroup) {
        return this.sliceFilter(new ColumnSlice[]{slice}, limit, toGroup);
    }

    private SliceQueryFilter sliceFilter(ColumnSlice[] slices, int limit, int toGroup) {
        return new SliceQueryFilter(slices, this.isReversed, limit, toGroup);
    }

    private int getLimit(List<ByteBuffer> variables) throws InvalidRequestException {
        int l = Integer.MAX_VALUE;
        if (this.limit != null) {
            ByteBuffer b = this.limit.bindAndGet(variables);
            if (b == null) {
                throw new InvalidRequestException("Invalid null value of limit");
            }
            try {
                Int32Type.instance.validate(b);
                l = (Integer)Int32Type.instance.compose(b);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        if (l <= 0) {
            throw new InvalidRequestException("LIMIT must be strictly positive");
        }
        if (!(this.sliceRestriction == null || this.sliceRestriction.isInclusive(Bound.START) && this.sliceRestriction.isInclusive(Bound.END) || l == Integer.MAX_VALUE)) {
            ++l;
        }
        return l;
    }

    private Collection<ByteBuffer> getKeys(List<ByteBuffer> variables) throws InvalidRequestException {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        ColumnNameBuilder builder = this.cfDef.getKeyNameBuilder();
        for (CFDefinition.Name name : this.cfDef.partitionKeys()) {
            Restriction r = this.keyRestrictions[name.position];
            assert (r != null && !r.isSlice());
            List<ByteBuffer> values = r.values(variables);
            if (builder.remainingCount() == 1) {
                for (ByteBuffer val : values) {
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
                    }
                    keys.add(builder.copy().add(val).build());
                }
                continue;
            }
            if (values.size() != 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
            }
            builder.add(val);
        }
        return keys;
    }

    private ByteBuffer getKeyBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        for (int i = 0; i < this.keyRestrictions.length; ++i) {
            if (this.keyRestrictions[i] != null) continue;
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return this.buildBound(b, this.cfDef.partitionKeys(), this.keyRestrictions, false, this.cfDef.getKeyNameBuilder(), variables).get(0);
    }

    private Token getTokenBound(Bound b, List<ByteBuffer> variables, IPartitioner<?> p) throws InvalidRequestException {
        ByteBuffer value;
        assert (this.onToken);
        Restriction keyRestriction = this.keyRestrictions[0];
        if (keyRestriction.isEQ()) {
            value = keyRestriction.values(variables).get(0);
        } else {
            Restriction.Slice slice = (Restriction.Slice)keyRestriction;
            if (!slice.hasBound(b)) {
                return p.getMinimumToken();
            }
            value = slice.bound(b, variables);
        }
        if (value == null) {
            throw new InvalidRequestException("Invalid null token value");
        }
        return p.getTokenFactory().fromByteArray(value);
    }

    private boolean includeKeyBound(Bound b) {
        for (Restriction r : this.keyRestrictions) {
            if (r == null) {
                return true;
            }
            if (!r.isSlice()) continue;
            return ((Restriction.Slice)r).isInclusive(b);
        }
        return true;
    }

    private boolean isColumnRange() {
        if (!this.cfDef.isCompact) {
            return this.cfDef.isComposite;
        }
        for (Restriction r : this.columnRestrictions) {
            if (r != null && !r.isSlice()) continue;
            return true;
        }
        return false;
    }

    private SortedSet<ByteBuffer> getRequestedColumns(List<ByteBuffer> variables) throws InvalidRequestException {
        assert (!this.isColumnRange());
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        Iterator<CFDefinition.Name> idIter = this.cfDef.clusteringColumns().iterator();
        for (Restriction r : this.columnRestrictions) {
            ByteBuffer val;
            ColumnIdentifier id = idIter.next().name;
            assert (r != null && !r.isSlice());
            List<ByteBuffer> values = r.values(variables);
            if (values.size() == 1) {
                val = values.get(0);
                if (val == null) {
                    throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", id));
                }
            } else {
                if (values.isEmpty()) {
                    return null;
                }
                TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfDef.cfm.comparator);
                Iterator<ByteBuffer> iter = values.iterator();
                while (iter.hasNext()) {
                    ColumnNameBuilder b;
                    ByteBuffer val2 = iter.next();
                    ColumnNameBuilder columnNameBuilder = b = iter.hasNext() ? builder.copy() : builder;
                    if (val2 == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", id));
                    }
                    b.add(val2);
                    if (this.cfDef.isCompact) {
                        columns.add(b.build());
                        continue;
                    }
                    columns.addAll(this.addSelectedColumns(b));
                }
                return columns;
            }
            builder.add(val);
        }
        return this.addSelectedColumns(builder);
    }

    private SortedSet<ByteBuffer> addSelectedColumns(ColumnNameBuilder builder) {
        if (this.cfDef.isCompact) {
            return FBUtilities.singleton(builder.build(), this.cfDef.cfm.comparator);
        }
        assert (!this.selectACollection());
        TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfDef.cfm.comparator);
        if (this.cfDef.isComposite && !this.cfDef.cfm.isSuper()) {
            columns.add(builder.copy().add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build());
            for (ColumnIdentifier id : this.selection.regularAndStaticColumnsToFetch()) {
                columns.add(builder.copy().add(id.key).build());
            }
        } else {
            Iterator<CFDefinition.Name> iter = this.cfDef.regularColumns().iterator();
            while (iter.hasNext()) {
                ColumnIdentifier name = iter.next().name;
                ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                ByteBuffer cname = b.add(name.key).build();
                columns.add(cname);
            }
        }
        return columns;
    }

    private boolean selectACollection() {
        if (!this.cfDef.hasCollections) {
            return false;
        }
        for (CFDefinition.Name name : this.selection.getColumnsList()) {
            if (!(name.type instanceof CollectionType)) continue;
            return true;
        }
        return false;
    }

    private List<ByteBuffer> buildBound(Bound bound, Collection<CFDefinition.Name> names, Restriction[] restrictions, boolean isReversed, ColumnNameBuilder builder, List<ByteBuffer> variables) throws InvalidRequestException {
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        Iterator<CFDefinition.Name> iter = names.iterator();
        while (iter.hasNext()) {
            CFDefinition.Name name;
            Restriction r = restrictions[name.position];
            name = iter.next();
            Bound b = isReversed == SelectStatement.isReversedType(name) ? bound : Bound.reverse(bound);
            if (SelectStatement.isNullRestriction(r, b)) {
                return Collections.singletonList(builder.componentCount() > 0 && eocBound == Bound.END ? builder.buildAsEndOfRange() : builder.build());
            }
            if (r.isSlice()) {
                builder.add(SelectStatement.getSliceValue(name, r, b, variables));
                Relation.Type relType = ((Restriction.Slice)r).getRelation(eocBound, b);
                while (iter.hasNext()) {
                    name = iter.next();
                    r = restrictions[name.position];
                    if (SelectStatement.isNullRestriction(r, b)) break;
                    builder.add(SelectStatement.getSliceValue(name, r, b, variables));
                }
                return Collections.singletonList(builder.buildForRelation(relType));
            }
            List<ByteBuffer> values = r.values(variables);
            if (values.size() != 1) {
                assert (name.position == names.size() - 1);
                TreeSet<ByteBuffer> s = new TreeSet<ByteBuffer>(isReversed ? this.cfDef.cfm.comparator.reverseComparator : this.cfDef.cfm.comparator);
                for (ByteBuffer val : values) {
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null clustering key part %s", name));
                    }
                    ColumnNameBuilder copy = builder.copy().add(val);
                    s.add(b == Bound.END && copy.remainingCount() > 0 ? copy.buildAsEndOfRange() : copy.build());
                }
                return new ArrayList<ByteBuffer>(s);
            }
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null clustering key part %s", name));
            }
            builder.add(val);
        }
        return Collections.singletonList(bound == Bound.END && builder.remainingCount() > 0 ? builder.buildAsEndOfRange() : builder.build());
    }

    private static boolean isNullRestriction(Restriction r, Bound b) {
        return r == null || r.isSlice() && !((Restriction.Slice)r).hasBound(b);
    }

    private static ByteBuffer getSliceValue(CFDefinition.Name name, Restriction r, Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        Restriction.Slice slice = (Restriction.Slice)r;
        assert (slice.hasBound(b));
        ByteBuffer val = slice.bound(b, variables);
        if (val == null) {
            throw new InvalidRequestException(String.format("Invalid null clustering key part %s", name));
        }
        return val;
    }

    private List<ByteBuffer> getRequestedBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.isColumnRange());
        return this.buildBound(b, this.cfDef.clusteringColumns(), this.columnRestrictions, this.isReversed, this.cfDef.getColumnNameBuilder(), variables);
    }

    public List<IndexExpression> getIndexExpressions(List<ByteBuffer> variables) throws InvalidRequestException {
        if (!this.usesSecondaryIndexing || this.restrictedNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (CFDefinition.Name name : this.restrictedNames) {
            Restriction restriction;
            switch (name.kind) {
                case KEY_ALIAS: {
                    restriction = this.keyRestrictions[name.position];
                    break;
                }
                case COLUMN_ALIAS: {
                    restriction = this.columnRestrictions[name.position];
                    break;
                }
                case COLUMN_METADATA: 
                case STATIC: {
                    restriction = this.metadataRestrictions.get(name);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (restriction.isSlice()) {
                Restriction.Slice slice = (Restriction.Slice)restriction;
                for (Bound b : Bound.values()) {
                    if (!slice.hasBound(b)) continue;
                    ByteBuffer value = slice.bound(b, variables);
                    if (value == null) {
                        throw new InvalidRequestException(String.format("Unsupported null value for indexed column %s", name));
                    }
                    if (value.remaining() > 65535) {
                        throw new InvalidRequestException("Index expression values may not be larger than 64K");
                    }
                    expressions.add(new IndexExpression(name.name.key, slice.getIndexOperator(b), value));
                }
                continue;
            }
            List<ByteBuffer> values = restriction.values(variables);
            if (values.size() != 1) {
                throw new InvalidRequestException("IN restrictions are not supported on indexed columns");
            }
            ByteBuffer value = values.get(0);
            if (value == null) {
                throw new InvalidRequestException(String.format("Unsupported null value for indexed column %s", name));
            }
            if (value.remaining() > 65535) {
                throw new InvalidRequestException("Index expression values may not be larger than 64K");
            }
            expressions.add(new IndexExpression(name.name.key, IndexOperator.EQ, value));
        }
        return expressions;
    }

    private ResultSet process(List<Row> rows, List<ByteBuffer> variables, int limit, long now) throws InvalidRequestException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(now);
        for (Row row : rows) {
            if (row.cf == null) continue;
            this.processColumnFamily(row.key.key, row.cf, variables, now, result);
        }
        ResultSet cqlRows = result.build();
        this.orderResults(cqlRows);
        if (this.isReversed) {
            cqlRows.reverse();
        }
        cqlRows.trim(limit);
        return cqlRows;
    }

    void processColumnFamily(ByteBuffer key, ColumnFamily cf, List<ByteBuffer> variables, long now, Selection.ResultSetBuilder result) throws InvalidRequestException {
        block29: {
            ByteBuffer[] keyComponents;
            block28: {
                ByteBuffer[] byteBufferArray;
                if (this.cfDef.hasCompositeKey) {
                    byteBufferArray = ((CompositeType)this.cfDef.cfm.getKeyValidator()).split(key);
                } else {
                    ByteBuffer[] byteBufferArray2 = new ByteBuffer[1];
                    byteBufferArray = byteBufferArray2;
                    byteBufferArray2[0] = key;
                }
                keyComponents = byteBufferArray;
                if (!this.parameters.isDistinct) break block28;
                if (cf.hasOnlyTombstones(now)) break block29;
                result.newRow();
                for (CFDefinition.Name name : this.selection.getColumnsList()) {
                    result.add(keyComponents[name.position]);
                }
                break block29;
            }
            if (this.cfDef.isCompact) {
                for (Column c : cf) {
                    if (c.isMarkedForDelete(now)) continue;
                    ByteBuffer[] components = null;
                    if (this.cfDef.isComposite) {
                        components = ((CompositeType)this.cfDef.cfm.comparator).split(c.name());
                    } else if (this.sliceRestriction != null) {
                        AbstractType<?> comp = this.cfDef.cfm.comparator;
                        if (!this.sliceRestriction.isInclusive(Bound.START) && comp.compare(c.name(), this.sliceRestriction.bound(Bound.START, variables)) == 0 || !this.sliceRestriction.isInclusive(Bound.END) && comp.compare(c.name(), this.sliceRestriction.bound(Bound.END, variables)) == 0) continue;
                    }
                    result.newRow();
                    block8: for (CFDefinition.Name name : this.selection.getColumnsList()) {
                        switch (name.kind) {
                            case KEY_ALIAS: {
                                result.add(keyComponents[name.position]);
                                continue block8;
                            }
                            case COLUMN_ALIAS: {
                                ByteBuffer val = this.cfDef.isComposite ? (name.position < components.length ? components[name.position] : null) : c.name();
                                result.add(val);
                                continue block8;
                            }
                            case VALUE_ALIAS: {
                                result.add(c);
                                continue block8;
                            }
                            case COLUMN_METADATA: 
                            case STATIC: {
                                throw new AssertionError();
                            }
                        }
                        throw new AssertionError();
                    }
                }
            } else if (this.cfDef.isComposite) {
                CompositeType composite = (CompositeType)this.cfDef.cfm.comparator;
                ColumnGroupMap.Builder builder = new ColumnGroupMap.Builder(composite, this.cfDef.hasCollections, now);
                for (Column c : cf) {
                    if (c.isMarkedForDelete(now)) continue;
                    builder.add(c);
                }
                Map<CFDefinition.Name, ByteBuffer> staticValues = Collections.emptyMap();
                if (!builder.isEmpty() && builder.firstGroup().isStatic) {
                    staticValues = new HashMap();
                    ColumnGroupMap group = builder.firstGroup();
                    for (CFDefinition.Name name : Iterables.filter(this.selection.getColumnsList(), isStaticFilter)) {
                        staticValues.put(name, name.type.isCollection() ? SelectStatement.getCollectionValue(name, group) : SelectStatement.getSimpleValue(name, group));
                    }
                    builder.discardFirst();
                    if (!staticValues.isEmpty() && builder.isEmpty() && !this.usesSecondaryIndexing && this.hasNoClusteringColumnsRestriction()) {
                        result.newRow();
                        for (CFDefinition.Name name : this.selection.getColumnsList()) {
                            if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS) {
                                result.add(keyComponents[name.position]);
                                continue;
                            }
                            result.add(name.kind == CFDefinition.Name.Kind.STATIC ? staticValues.get(name) : null);
                        }
                        return;
                    }
                }
                for (ColumnGroupMap group : builder.groups()) {
                    this.handleGroup(this.selection, result, keyComponents, group, staticValues);
                }
            } else {
                if (cf.hasOnlyTombstones(now)) {
                    return;
                }
                result.newRow();
                for (CFDefinition.Name name : this.selection.getColumnsList()) {
                    if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS) {
                        result.add(keyComponents[name.position]);
                        continue;
                    }
                    result.add(cf.getColumn(name.name.key));
                }
            }
        }
    }

    private boolean hasNoClusteringColumnsRestriction() {
        for (int i = 0; i < this.columnRestrictions.length; ++i) {
            if (this.columnRestrictions[i] == null) continue;
            return false;
        }
        return true;
    }

    private boolean needsPostQueryOrdering() {
        return this.keyIsInRelation && !this.parameters.orderings.isEmpty();
    }

    private void orderResults(ResultSet cqlRows) {
        if (cqlRows.size() == 0 || !this.needsPostQueryOrdering()) {
            return;
        }
        assert (this.orderingIndexes != null);
        if (this.parameters.orderings.size() == 1) {
            CFDefinition.Name ordering = this.cfDef.get((ColumnIdentifier)this.parameters.orderings.keySet().iterator().next());
            Collections.sort(cqlRows.rows, new SingleColumnComparator(this.orderingIndexes.get(ordering), ordering.type));
            return;
        }
        ArrayList<AbstractType> types = new ArrayList<AbstractType>(this.parameters.orderings.size());
        int[] positions = new int[this.parameters.orderings.size()];
        int idx = 0;
        for (ColumnIdentifier identifier : this.parameters.orderings.keySet()) {
            CFDefinition.Name orderingColumn = this.cfDef.get(identifier);
            types.add(orderingColumn.type);
            positions[idx++] = this.orderingIndexes.get(orderingColumn);
        }
        Collections.sort(cqlRows.rows, new CompositeComparator(types, positions));
    }

    private void handleGroup(Selection selection, Selection.ResultSetBuilder result, ByteBuffer[] keyComponents, ColumnGroupMap columns, Map<CFDefinition.Name, ByteBuffer> staticValues) throws InvalidRequestException {
        result.newRow();
        for (CFDefinition.Name name : selection.getColumnsList()) {
            switch (name.kind) {
                case KEY_ALIAS: {
                    result.add(keyComponents[name.position]);
                    break;
                }
                case COLUMN_ALIAS: {
                    result.add(columns.getKeyComponent(name.position));
                    break;
                }
                case VALUE_ALIAS: {
                    throw new AssertionError();
                }
                case COLUMN_METADATA: {
                    if (name.type.isCollection()) {
                        result.add(SelectStatement.getCollectionValue(name, columns));
                        break;
                    }
                    result.add(columns.getSimple(name.name.key));
                    break;
                }
                case STATIC: {
                    result.add(staticValues.get(name));
                }
            }
        }
    }

    private static ByteBuffer getCollectionValue(CFDefinition.Name name, ColumnGroupMap columns) {
        List<Pair<ByteBuffer, Column>> collection = columns.getCollection(name.name.key);
        return collection == null ? null : ((CollectionType)name.type).serialize(collection);
    }

    private static ByteBuffer getSimpleValue(CFDefinition.Name name, ColumnGroupMap columns) {
        Column c = columns.getSimple(name.name.key);
        return c == null ? null : c.value();
    }

    private static boolean isReversedType(CFDefinition.Name name) {
        return name.type instanceof ReversedType;
    }

    private boolean columnFilterIsIdentity() {
        for (Restriction r : this.columnRestrictions) {
            if (r == null) continue;
            return false;
        }
        return true;
    }

    private boolean hasClusteringColumnsRestriction() {
        for (int i = 0; i < this.columnRestrictions.length; ++i) {
            if (this.columnRestrictions[i] == null) continue;
            return true;
        }
        return false;
    }

    private static class CompositeComparator
    implements Comparator<List<ByteBuffer>> {
        private final List<AbstractType<?>> orderTypes;
        private final int[] positions;

        private CompositeComparator(List<AbstractType<?>> orderTypes, int[] positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.length; ++i) {
                ByteBuffer bValue;
                int columnPos;
                ByteBuffer aValue;
                AbstractType<?> type = this.orderTypes.get(i);
                int comparison = type.compare(aValue = a.get(columnPos = this.positions[i]), bValue = b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    implements Comparator<List<ByteBuffer>> {
        private final int index;
        private final AbstractType<?> comparator;

        public SingleColumnComparator(int columnIndex, AbstractType<?> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.comparator.compare(a.get(this.index), b.get(this.index));
        }
    }

    public static class Parameters {
        private final Map<ColumnIdentifier, Boolean> orderings;
        private final boolean isDistinct;
        private final boolean isCount;
        private final ColumnIdentifier countAlias;
        private final boolean allowFiltering;

        public Parameters(Map<ColumnIdentifier, Boolean> orderings, boolean isDistinct, boolean isCount, ColumnIdentifier countAlias, boolean allowFiltering) {
            this.orderings = orderings;
            this.isDistinct = isDistinct;
            this.isCount = isCount;
            this.countAlias = countAlias;
            this.allowFiltering = allowFiltering;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<RawSelector> selectClause;
        private final List<Relation> whereClause;
        private final Term.Raw limit;

        public RawStatement(CFName cfName, Parameters parameters, List<RawSelector> selectClause, List<Relation> whereClause, Term.Raw limit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
            this.limit = limit;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            Selection selection;
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            CFDefinition cfDef = cfm.getCfDef();
            VariableSpecifications names = this.getBoundVariables();
            if (this.parameters.isCount && !this.selectClause.isEmpty()) {
                throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
            }
            Selection selection2 = selection = this.selectClause.isEmpty() ? Selection.wildcard(cfDef) : Selection.fromSelectors(cfDef, this.selectClause);
            if (this.parameters.isDistinct) {
                this.validateDistinctSelection(selection.getColumnsList(), cfDef.partitionKeys());
            }
            Term prepLimit = null;
            if (this.limit != null) {
                prepLimit = this.limit.prepare(this.limitReceiver());
                prepLimit.collectMarkerSpecification(names);
            }
            SelectStatement stmt = new SelectStatement(cfDef, names.size(), this.parameters, selection, prepLimit);
            boolean hasQueriableIndex = false;
            boolean hasQueriableClusteringColumnIndex = false;
            for (Relation rel : this.whereClause) {
                CFDefinition.Name name = cfDef.get(rel.getEntity());
                if (name == null) {
                    if (this.containsAlias(rel.getEntity())) {
                        throw new InvalidRequestException(String.format("Aliases aren't allowed in where clause ('%s')", rel));
                    }
                    throw new InvalidRequestException(String.format("Undefined name %s in where clause ('%s')", rel.getEntity(), rel));
                }
                ColumnDefinition def = cfDef.cfm.getColumnDefinition(name.name.key);
                stmt.restrictedNames.add(name);
                if (def.isIndexed() && rel.operator() == Relation.Type.EQ) {
                    hasQueriableIndex = true;
                    if (name.kind == CFDefinition.Name.Kind.COLUMN_ALIAS) {
                        hasQueriableClusteringColumnIndex = true;
                    }
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        ((SelectStatement)stmt).keyRestrictions[name.position] = this.updateRestriction(cfm, name, stmt.keyRestrictions[name.position], rel, names);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        ((SelectStatement)stmt).columnRestrictions[name.position] = this.updateRestriction(cfm, name, stmt.columnRestrictions[name.position], rel, names);
                        break;
                    }
                    case VALUE_ALIAS: {
                        throw new InvalidRequestException(String.format("Predicates on the non-primary-key column (%s) of a COMPACT table are not yet supported", name.name));
                    }
                    case COLUMN_METADATA: 
                    case STATIC: {
                        Restriction r = this.updateRestriction(cfm, name, (Restriction)stmt.metadataRestrictions.get(name), rel, names);
                        if (r.isIN() && !((Restriction.IN)r).canHaveOnlyOneValue()) {
                            throw new InvalidRequestException(String.format("IN predicates on non-primary-key columns (%s) is not yet supported", name));
                        }
                        stmt.metadataRestrictions.put(name, r);
                    }
                }
            }
            boolean canRestrictFurtherComponents = true;
            CFDefinition.Name previous = null;
            stmt.keyIsInRelation = false;
            Iterator<CFDefinition.Name> iter = cfDef.partitionKeys().iterator();
            for (int i = 0; i < stmt.keyRestrictions.length; ++i) {
                CFDefinition.Name cname = iter.next();
                Restriction restriction = stmt.keyRestrictions[i];
                if (restriction == null) {
                    if (stmt.onToken) {
                        throw new InvalidRequestException("The token() function must be applied to all partition key components or none of them");
                    }
                    if (i > 0 && stmt.keyRestrictions[i - 1] != null) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            stmt.isKeyRange = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("Partition key part %s must be restricted since preceding part is", cname));
                    }
                    stmt.isKeyRange = true;
                    canRestrictFurtherComponents = false;
                } else {
                    if (!canRestrictFurtherComponents) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("partition key part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cname, previous));
                    }
                    if (restriction.isOnToken()) {
                        stmt.isKeyRange = true;
                        stmt.onToken = true;
                    } else {
                        if (stmt.onToken) {
                            throw new InvalidRequestException(String.format("The token() function must be applied to all partition key components or none of them", new Object[0]));
                        }
                        if (!restriction.isSlice()) {
                            if (restriction.isIN()) {
                                if (i != stmt.keyRestrictions.length - 1) {
                                    throw new InvalidRequestException(String.format("Partition KEY part %s cannot be restricted by IN relation (only the last part of the partition key can)", cname));
                                }
                                stmt.keyIsInRelation = true;
                            }
                        } else {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on the partition key (unless you use the token() function)");
                        }
                    }
                }
                previous = cname;
            }
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedNames.removeAll(cfDef.partitionKeys());
            }
            if (stmt.selectsOnlyStaticColumns && stmt.hasClusteringColumnsRestriction()) {
                throw new InvalidRequestException("Cannot restrict clustering columns when selecting only static columns");
            }
            canRestrictFurtherComponents = true;
            previous = null;
            boolean previousIsSlice = false;
            iter = cfDef.clusteringColumns().iterator();
            for (int i = 0; i < stmt.columnRestrictions.length; ++i) {
                CFDefinition.Name cname = iter.next();
                Restriction restriction = stmt.columnRestrictions[i];
                if (restriction == null) {
                    canRestrictFurtherComponents = false;
                    previousIsSlice = false;
                } else if (!canRestrictFurtherComponents) {
                    boolean hasTuple = false;
                    boolean hasRestrictedNotTuple = false;
                    if (!(previousIsSlice && restriction.isSlice() && ((Restriction.Slice)restriction).isPartOfTuple())) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cname, previous));
                    }
                } else if (restriction.isSlice()) {
                    canRestrictFurtherComponents = false;
                    previousIsSlice = true;
                    Restriction.Slice slice = (Restriction.Slice)restriction;
                    if (!(cfDef.isComposite || slice.isInclusive(Bound.START) && slice.isInclusive(Bound.END))) {
                        stmt.sliceRestriction = slice;
                    }
                } else if (restriction.isIN()) {
                    if (i != stmt.columnRestrictions.length - 1) {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted by IN relation", cname));
                    }
                    if (stmt.selectACollection()) {
                        throw new InvalidRequestException(String.format("Cannot restrict PRIMARY KEY part %s by IN relation as a collection is selected by the query", cname));
                    }
                }
                previous = cname;
            }
            if (stmt.isKeyRange && hasQueriableClusteringColumnIndex) {
                stmt.usesSecondaryIndexing = true;
            }
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedNames.removeAll(cfDef.clusteringColumns());
            }
            if (!stmt.metadataRestrictions.isEmpty()) {
                if (!hasQueriableIndex) {
                    throw new InvalidRequestException("No indexed columns present in by-columns clause with Equal operator");
                }
                stmt.usesSecondaryIndexing = true;
            }
            if (stmt.usesSecondaryIndexing) {
                if (stmt.keyIsInRelation) {
                    throw new InvalidRequestException("Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
                }
                if (stmt.selectsOnlyStaticColumns) {
                    throw new InvalidRequestException("Queries using 2ndary indexes don't support selecting only static columns");
                }
            }
            if (!stmt.parameters.orderings.isEmpty()) {
                if (stmt.usesSecondaryIndexing) {
                    throw new InvalidRequestException("ORDER BY with 2ndary indexes is not supported.");
                }
                if (stmt.isKeyRange) {
                    throw new InvalidRequestException("ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
                }
                if (stmt.keyIsInRelation) {
                    stmt.orderingIndexes = new HashMap();
                    for (ColumnIdentifier column : stmt.parameters.orderings.keySet()) {
                        final CFDefinition.Name name = cfDef.get(column);
                        if (name == null) {
                            if (this.containsAlias(column)) {
                                throw new InvalidRequestException(String.format("Aliases are not allowed in order by clause ('%s')", column));
                            }
                            throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
                        }
                        if (this.selectClause.isEmpty()) {
                            stmt.orderingIndexes.put(name, Iterables.indexOf((Iterable)cfDef, (Predicate)new Predicate<CFDefinition.Name>(){

                                public boolean apply(CFDefinition.Name n) {
                                    return name.equals(n);
                                }
                            }));
                            continue;
                        }
                        boolean hasColumn = false;
                        for (int i = 0; i < this.selectClause.size(); ++i) {
                            RawSelector selector = this.selectClause.get(i);
                            if (!name.name.equals(selector.selectable)) continue;
                            stmt.orderingIndexes.put(name, i);
                            hasColumn = true;
                            break;
                        }
                        if (hasColumn) continue;
                        throw new InvalidRequestException("ORDER BY could not be used on columns missing in select clause.");
                    }
                }
                Boolean[] reversedMap = new Boolean[cfDef.clusteringColumnsCount()];
                int i = 0;
                for (Map.Entry entry : stmt.parameters.orderings.entrySet()) {
                    ColumnIdentifier column = (ColumnIdentifier)entry.getKey();
                    boolean reversed = (Boolean)entry.getValue();
                    CFDefinition.Name name = cfDef.get(column);
                    if (name == null) {
                        if (this.containsAlias(column)) {
                            throw new InvalidRequestException(String.format("Aliases are not allowed in order by clause ('%s')", column));
                        }
                        throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
                    }
                    if (name.kind != CFDefinition.Name.Kind.COLUMN_ALIAS) {
                        throw new InvalidRequestException(String.format("Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", column));
                    }
                    if (i++ != name.position) {
                        throw new InvalidRequestException(String.format("Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY", new Object[0]));
                    }
                    reversedMap[name.position] = reversed != SelectStatement.isReversedType(name);
                }
                Boolean isReversed = null;
                for (Boolean b : reversedMap) {
                    if (b == null) continue;
                    if (isReversed == null) {
                        isReversed = b;
                        continue;
                    }
                    if (isReversed == b) continue;
                    throw new InvalidRequestException(String.format("Unsupported order by relation", new Object[0]));
                }
                assert (isReversed != null);
                stmt.isReversed = isReversed;
            }
            if (!this.parameters.allowFiltering && (stmt.isKeyRange || stmt.usesSecondaryIndexing) && (stmt.restrictedNames.size() > 1 || stmt.restrictedNames.isEmpty() && !stmt.columnFilterIsIdentity())) {
                throw new InvalidRequestException("Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
            return new ParsedStatement.Prepared((CQLStatement)stmt, names);
        }

        private void validateDistinctSelection(Collection<CFDefinition.Name> requestedColumns, Collection<CFDefinition.Name> partitionKey) throws InvalidRequestException {
            for (CFDefinition.Name name : requestedColumns) {
                if (partitionKey.contains(name)) continue;
                throw new InvalidRequestException(String.format("SELECT DISTINCT queries must only request partition key columns (not %s)", name));
            }
            for (CFDefinition.Name name : partitionKey) {
                if (requestedColumns.contains(name)) continue;
                throw new InvalidRequestException(String.format("SELECT DISTINCT queries must request all the partition key columns (missing %s)", name));
            }
        }

        private boolean containsAlias(final ColumnIdentifier name) {
            return Iterables.any(this.selectClause, (Predicate)new Predicate<RawSelector>(){

                public boolean apply(RawSelector raw) {
                    return name.equals(raw.alias);
                }
            });
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        Restriction updateRestriction(CFMetaData cfm, CFDefinition.Name name, Restriction restriction, Relation newRel, VariableSpecifications boundNames) throws InvalidRequestException {
            ColumnSpecification receiver = name;
            if (newRel.onToken) {
                if (name.kind != CFDefinition.Name.Kind.KEY_ALIAS) {
                    throw new InvalidRequestException(String.format("The token() function is only supported on the partition key, found on %s", name));
                }
                receiver = new ColumnSpecification(name.ksName, name.cfName, new ColumnIdentifier("partition key token", true), StorageService.getPartitioner().getTokenValidator());
            }
            if (newRel.previousInTuple != null && name.kind != CFDefinition.Name.Kind.COLUMN_ALIAS) {
                throw new InvalidRequestException(String.format("Tuple notation can only be used on clustering columns but found on %s", name));
            }
            switch (newRel.operator()) {
                case EQ: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes an Equal", name));
                    }
                    Term t = newRel.getValue().prepare(receiver);
                    t.collectMarkerSpecification(boundNames);
                    restriction = new Restriction.EQ(t, newRel.onToken);
                    break;
                }
                case IN: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes a IN", name));
                    }
                    if (newRel.getInValues() == null) {
                        assert (newRel.getValue() != null);
                        Term t = newRel.getValue().prepare(receiver);
                        t.collectMarkerSpecification(boundNames);
                        restriction = Restriction.IN.create(t);
                        break;
                    }
                    ArrayList<Term> inValues = new ArrayList<Term>(newRel.getInValues().size());
                    for (Term.Raw raw : newRel.getInValues()) {
                        Term t = raw.prepare(receiver);
                        t.collectMarkerSpecification(boundNames);
                        inValues.add(t);
                    }
                    restriction = Restriction.IN.create(inValues);
                    break;
                }
                case GT: 
                case GTE: 
                case LT: 
                case LTE: {
                    if (restriction == null) {
                        restriction = new Restriction.Slice(newRel.onToken);
                    } else if (!restriction.isSlice()) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by both an equal and an inequal relation", name));
                    }
                    Term t = newRel.getValue().prepare(receiver);
                    t.collectMarkerSpecification(boundNames);
                    if (!(newRel.previousInTuple == null || name.position != 0 && cfm.clusteringKeyColumns().get((int)(name.position - 1)).name.equals(newRel.previousInTuple.key))) {
                        throw new InvalidRequestException(String.format("Invalid tuple notation, column %s is not before column %s in the clustering order", newRel.previousInTuple, name.name));
                    }
                    ((Restriction.Slice)restriction).setBound(name.name, newRel.operator(), t, newRel.previousInTuple);
                }
            }
            return restriction;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.cfName).add("selectClause", this.selectClause).add("whereClause", this.whereClause).add("isDistinct", this.parameters.isDistinct).add("isCount", this.parameters.isCount).toString();
        }
    }
}

