/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefsTables {
    private static final Logger logger = LoggerFactory.getLogger(DefsTables.class);

    public static Collection<KSMetaData> loadFromKeyspace() {
        List<Row> serializedSchema = SystemKeyspace.serializedSchema("schema_keyspaces");
        ArrayList<KSMetaData> keyspaces = new ArrayList<KSMetaData>(serializedSchema.size());
        for (Row row : serializedSchema) {
            if (Schema.invalidSchemaRow(row) || Schema.ignoredSchemaRow(row)) continue;
            keyspaces.add(KSMetaData.fromSchema(row, DefsTables.serializedColumnFamilies(row.key)));
        }
        return keyspaces;
    }

    public static ByteBuffer searchComposite(String name, boolean start) {
        assert (name != null);
        ByteBuffer nameBytes = UTF8Type.instance.decompose(name);
        int length = nameBytes.remaining();
        byte[] bytes = new byte[2 + length + 1];
        bytes[0] = (byte)(length >> 8 & 0xFF);
        bytes[1] = (byte)(length & 0xFF);
        ByteBufferUtil.arrayCopy(nameBytes, 0, bytes, 2, length);
        bytes[bytes.length - 1] = (byte)(!start ? 1 : 0);
        return ByteBuffer.wrap(bytes);
    }

    private static Row serializedColumnFamilies(DecoratedKey ksNameKey) {
        ColumnFamilyStore cfsStore = SystemKeyspace.schemaCFS("schema_columnfamilies");
        return new Row(ksNameKey, cfsStore.getColumnFamily(QueryFilter.getIdentityFilter(ksNameKey, "schema_columnfamilies", System.currentTimeMillis())));
    }

    public static synchronized void mergeSchema(Collection<RowMutation> mutations) throws ConfigurationException, IOException {
        Map<DecoratedKey, ColumnFamily> oldKeyspaces = SystemKeyspace.getSchema("schema_keyspaces");
        Map<DecoratedKey, ColumnFamily> oldColumnFamilies = SystemKeyspace.getSchema("schema_columnfamilies");
        for (RowMutation mutation : mutations) {
            mutation.apply();
        }
        if (!StorageService.instance.isClientMode()) {
            DefsTables.flushSchemaCFs();
        }
        Map<DecoratedKey, ColumnFamily> newKeyspaces = SystemKeyspace.getSchema("schema_keyspaces");
        Map<DecoratedKey, ColumnFamily> newColumnFamilies = SystemKeyspace.getSchema("schema_columnfamilies");
        Set<String> keyspacesToDrop = DefsTables.mergeKeyspaces(oldKeyspaces, newKeyspaces);
        DefsTables.mergeColumnFamilies(oldColumnFamilies, newColumnFamilies);
        for (String keyspaceToDrop : keyspacesToDrop) {
            DefsTables.dropKeyspace(keyspaceToDrop);
        }
        Schema.instance.updateVersionAndAnnounce();
    }

    private static Set<String> mergeKeyspaces(Map<DecoratedKey, ColumnFamily> old, Map<DecoratedKey, ColumnFamily> updated) {
        MapDifference diff = Maps.difference(old, updated);
        for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
            ColumnFamily ksAttrs = (ColumnFamily)entry.getValue();
            if (ksAttrs.getColumnCount() == 0) continue;
            DefsTables.addKeyspace(KSMetaData.fromSchema(new Row((DecoratedKey)entry.getKey(), (ColumnFamily)entry.getValue()), Collections.emptyList()));
        }
        Map modifiedEntries = diff.entriesDiffering();
        ArrayList leftToProcess = new ArrayList(modifiedEntries.size());
        for (Map.Entry entry : modifiedEntries.entrySet()) {
            ColumnFamily prevValue = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).leftValue();
            ColumnFamily newValue = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).rightValue();
            if (prevValue.getColumnCount() == 0) {
                DefsTables.addKeyspace(KSMetaData.fromSchema(new Row((DecoratedKey)entry.getKey(), newValue), Collections.emptyList()));
                continue;
            }
            leftToProcess.add(entry.getKey());
        }
        if (leftToProcess.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> keyspacesToDrop = new HashSet<String>();
        for (DecoratedKey key : leftToProcess) {
            MapDifference.ValueDifference valueDiff = (MapDifference.ValueDifference)modifiedEntries.get(key);
            ColumnFamily newState = (ColumnFamily)valueDiff.rightValue();
            if (newState.getColumnCount() == 0) {
                keyspacesToDrop.add(AsciiType.instance.getString(key.key));
                continue;
            }
            DefsTables.updateKeyspace(KSMetaData.fromSchema(new Row(key, newState), Collections.emptyList()));
        }
        return keyspacesToDrop;
    }

    private static void mergeColumnFamilies(Map<DecoratedKey, ColumnFamily> old, Map<DecoratedKey, ColumnFamily> updated) {
        MapDifference diff = Maps.difference(old, updated);
        for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
            ColumnFamily cfAttrs = (ColumnFamily)entry.getValue();
            if (cfAttrs.getColumnCount() == 0) continue;
            Map<String, CFMetaData> cfDefs = KSMetaData.deserializeColumnFamilies(new Row((DecoratedKey)entry.getKey(), cfAttrs));
            for (CFMetaData cfDef : cfDefs.values()) {
                DefsTables.addColumnFamily(cfDef);
            }
        }
        Map modifiedEntries = diff.entriesDiffering();
        for (DecoratedKey keyspace : modifiedEntries.keySet()) {
            MapDifference.ValueDifference valueDiff = (MapDifference.ValueDifference)modifiedEntries.get(keyspace);
            ColumnFamily prevValue = (ColumnFamily)valueDiff.leftValue();
            ColumnFamily newValue = (ColumnFamily)valueDiff.rightValue();
            Row newRow = new Row(keyspace, newValue);
            if (prevValue.getColumnCount() == 0) {
                for (CFMetaData cfm : KSMetaData.deserializeColumnFamilies(newRow).values()) {
                    DefsTables.addColumnFamily(cfm);
                }
                continue;
            }
            if (newValue.getColumnCount() == 0) {
                for (CFMetaData cfm : KSMetaData.deserializeColumnFamilies(new Row(keyspace, prevValue)).values()) {
                    DefsTables.dropColumnFamily(cfm.ksName, cfm.cfName);
                }
                continue;
            }
            String ksName = AsciiType.instance.getString(keyspace.key);
            HashMap<String, CFMetaData> oldCfDefs = new HashMap<String, CFMetaData>();
            for (CFMetaData cfm : Schema.instance.getKSMetaData(ksName).cfMetaData().values()) {
                oldCfDefs.put(cfm.cfName, cfm);
            }
            Map<String, CFMetaData> newCfDefs = KSMetaData.deserializeColumnFamilies(newRow);
            MapDifference cfDefDiff = Maps.difference(oldCfDefs, newCfDefs);
            for (CFMetaData cfDef : cfDefDiff.entriesOnlyOnRight().values()) {
                DefsTables.addColumnFamily(cfDef);
            }
            for (CFMetaData cfDef : cfDefDiff.entriesOnlyOnLeft().values()) {
                DefsTables.dropColumnFamily(cfDef.ksName, cfDef.cfName);
            }
            for (CFMetaData cfDef : cfDefDiff.entriesDiffering().values()) {
                DefsTables.updateColumnFamily((CFMetaData)cfDef.rightValue());
            }
        }
    }

    private static void addKeyspace(KSMetaData ksm) {
        assert (Schema.instance.getKSMetaData(ksm.name) == null);
        Schema.instance.load(ksm);
        if (!StorageService.instance.isClientMode()) {
            Keyspace.open(ksm.name);
            MigrationManager.instance.notifyCreateKeyspace(ksm);
        }
    }

    private static void addColumnFamily(CFMetaData cfm) {
        assert (Schema.instance.getCFMetaData(cfm.ksName, cfm.cfName) == null);
        KSMetaData ksm = Schema.instance.getKSMetaData(cfm.ksName);
        ksm = KSMetaData.cloneWith(ksm, Iterables.concat(ksm.cfMetaData().values(), Collections.singleton(cfm)));
        logger.info("Loading " + cfm);
        Schema.instance.load(cfm);
        Keyspace.open(cfm.ksName);
        Schema.instance.setKeyspaceDefinition(ksm);
        if (!StorageService.instance.isClientMode()) {
            Keyspace.open(ksm.name).initCf(cfm.cfId, cfm.cfName, true);
            MigrationManager.instance.notifyCreateColumnFamily(cfm);
        }
    }

    private static void updateKeyspace(KSMetaData newState) {
        KSMetaData oldKsm = Schema.instance.getKSMetaData(newState.name);
        assert (oldKsm != null);
        KSMetaData newKsm = KSMetaData.cloneWith(oldKsm.reloadAttributes(), oldKsm.cfMetaData().values());
        Schema.instance.setKeyspaceDefinition(newKsm);
        if (!StorageService.instance.isClientMode()) {
            Keyspace.open(newState.name).createReplicationStrategy(newKsm);
            MigrationManager.instance.notifyUpdateKeyspace(newKsm);
        }
    }

    private static void updateColumnFamily(CFMetaData newState) {
        CFMetaData cfm = Schema.instance.getCFMetaData(newState.ksName, newState.cfName);
        assert (cfm != null);
        cfm.reload();
        if (!StorageService.instance.isClientMode()) {
            Keyspace keyspace = Keyspace.open(cfm.ksName);
            keyspace.getColumnFamilyStore(cfm.cfName).reload();
            MigrationManager.instance.notifyUpdateColumnFamily(cfm);
        }
    }

    private static void dropKeyspace(String ksName) {
        KSMetaData ksm = Schema.instance.getKSMetaData(ksName);
        String snapshotName = Keyspace.getTimestampedSnapshotName(ksName);
        CompactionManager.instance.interruptCompactionFor(ksm.cfMetaData().values(), true);
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            ColumnFamilyStore cfs = Keyspace.open(ksm.name).getColumnFamilyStore(cfm.cfName);
            Schema.instance.purge(cfm);
            if (StorageService.instance.isClientMode()) continue;
            if (DatabaseDescriptor.isAutoSnapshot()) {
                cfs.snapshot(snapshotName);
            }
            Keyspace.open(ksm.name).dropCf(cfm.cfId);
        }
        Keyspace.clear(ksm.name);
        Schema.instance.clearKeyspaceDefinition(ksm);
        if (!StorageService.instance.isClientMode()) {
            MigrationManager.instance.notifyDropKeyspace(ksm);
        }
    }

    private static void dropColumnFamily(String ksName, String cfName) {
        KSMetaData ksm = Schema.instance.getKSMetaData(ksName);
        assert (ksm != null);
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(cfName);
        assert (cfs != null);
        CFMetaData cfm = ksm.cfMetaData().get(cfName);
        Schema.instance.purge(cfm);
        Schema.instance.setKeyspaceDefinition(DefsTables.makeNewKeyspaceDefinition(ksm, cfm));
        CompactionManager.instance.interruptCompactionFor(Arrays.asList(cfm), true);
        if (!StorageService.instance.isClientMode()) {
            if (DatabaseDescriptor.isAutoSnapshot()) {
                cfs.snapshot(Keyspace.getTimestampedSnapshotName(cfs.name));
            }
            Keyspace.open(ksm.name).dropCf(cfm.cfId);
            MigrationManager.instance.notifyDropColumnFamily(cfm);
        }
    }

    private static KSMetaData makeNewKeyspaceDefinition(KSMetaData ksm, CFMetaData toExclude) {
        ArrayList<CFMetaData> newCfs = new ArrayList<CFMetaData>(ksm.cfMetaData().values());
        newCfs.remove(toExclude);
        assert (newCfs.size() == ksm.cfMetaData().size() - 1);
        return KSMetaData.cloneWith(ksm, newCfs);
    }

    private static void flushSchemaCFs() {
        SystemKeyspace.forceBlockingFlush("schema_keyspaces");
        SystemKeyspace.forceBlockingFlush("schema_columnfamilies");
        SystemKeyspace.forceBlockingFlush("schema_columns");
        SystemKeyspace.forceBlockingFlush("schema_triggers");
    }
}

