/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import org.apache.cassandra.db.AbstractRangeCommand;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;

public class RangeSliceVerbHandler
implements IVerbHandler<AbstractRangeCommand> {
    @Override
    public void doVerb(MessageIn<AbstractRangeCommand> message, int id) {
        try {
            if (StorageService.instance.isBootstrapMode()) {
                throw new RuntimeException("Cannot service reads while bootstrapping!");
            }
            RangeSliceReply reply = new RangeSliceReply(((AbstractRangeCommand)message.payload).executeLocally());
            Tracing.trace("Enqueuing response to {}", message.from);
            MessagingService.instance().sendReply(reply.createMessage(), id, message.from);
        }
        catch (TombstoneOverwhelmingException e) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

