/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.management;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamSummary;
import org.apache.cassandra.streaming.management.ProgressInfoCompositeData;
import org.apache.cassandra.streaming.management.StreamSummaryCompositeData;

public class SessionInfoCompositeData {
    private static final String[] ITEM_NAMES = new String[]{"planId", "peer", "receivingSummaries", "sendingSummaries", "state", "receivingFiles", "sendingFiles"};
    private static final String[] ITEM_DESCS = new String[]{"Plan ID", "Session peer", "Summaries of receiving data", "Summaries of sending data", "Current session state", "Receiving files", "Sending files"};
    private static final OpenType<?>[] ITEM_TYPES;
    public static final CompositeType COMPOSITE_TYPE;

    public static CompositeData toCompositeData(final UUID planId, SessionInfo sessionInfo) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(ITEM_NAMES[0], planId.toString());
        valueMap.put(ITEM_NAMES[1], sessionInfo.peer.getHostAddress());
        Function<StreamSummary, CompositeData> fromStreamSummary = new Function<StreamSummary, CompositeData>(){

            public CompositeData apply(StreamSummary input) {
                return StreamSummaryCompositeData.toCompositeData(input);
            }
        };
        valueMap.put(ITEM_NAMES[2], SessionInfoCompositeData.toArrayOfCompositeData(sessionInfo.receivingSummaries, fromStreamSummary));
        valueMap.put(ITEM_NAMES[3], SessionInfoCompositeData.toArrayOfCompositeData(sessionInfo.sendingSummaries, fromStreamSummary));
        valueMap.put(ITEM_NAMES[4], sessionInfo.state.name());
        Function<ProgressInfo, CompositeData> fromProgressInfo = new Function<ProgressInfo, CompositeData>(){

            public CompositeData apply(ProgressInfo input) {
                return ProgressInfoCompositeData.toCompositeData(planId, input);
            }
        };
        valueMap.put(ITEM_NAMES[5], SessionInfoCompositeData.toArrayOfCompositeData(sessionInfo.getReceivingFiles(), fromProgressInfo));
        valueMap.put(ITEM_NAMES[6], SessionInfoCompositeData.toArrayOfCompositeData(sessionInfo.getSendingFiles(), fromProgressInfo));
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, valueMap);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static SessionInfo fromCompositeData(CompositeData cd) {
        InetAddress peer;
        assert (cd.getCompositeType().equals(COMPOSITE_TYPE));
        Object[] values = cd.getAll(ITEM_NAMES);
        try {
            peer = InetAddress.getByName((String)values[1]);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Function<CompositeData, StreamSummary> toStreamSummary = new Function<CompositeData, StreamSummary>(){

            public StreamSummary apply(CompositeData input) {
                return StreamSummaryCompositeData.fromCompositeData(input);
            }
        };
        SessionInfo info = new SessionInfo(peer, SessionInfoCompositeData.fromArrayOfCompositeData((CompositeData[])values[2], toStreamSummary), SessionInfoCompositeData.fromArrayOfCompositeData((CompositeData[])values[3], toStreamSummary), StreamSession.State.valueOf((String)values[4]));
        Function<CompositeData, ProgressInfo> toProgressInfo = new Function<CompositeData, ProgressInfo>(){

            public ProgressInfo apply(CompositeData input) {
                return ProgressInfoCompositeData.fromCompositeData(input);
            }
        };
        for (ProgressInfo progress : SessionInfoCompositeData.fromArrayOfCompositeData((CompositeData[])values[5], toProgressInfo)) {
            info.updateProgress(progress);
        }
        for (ProgressInfo progress : SessionInfoCompositeData.fromArrayOfCompositeData((CompositeData[])values[6], toProgressInfo)) {
            info.updateProgress(progress);
        }
        return info;
    }

    private static <T> Collection<T> fromArrayOfCompositeData(CompositeData[] cds, Function<CompositeData, T> func) {
        return Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(cds), func));
    }

    private static <T> CompositeData[] toArrayOfCompositeData(Collection<T> toConvert, Function<T, CompositeData> func) {
        CompositeData[] composites = new CompositeData[toConvert.size()];
        return Lists.newArrayList((Iterable)Iterables.transform(toConvert, func)).toArray(composites);
    }

    static {
        try {
            ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, ArrayType.getArrayType(StreamSummaryCompositeData.COMPOSITE_TYPE), ArrayType.getArrayType(StreamSummaryCompositeData.COMPOSITE_TYPE), SimpleType.STRING, ArrayType.getArrayType(ProgressInfoCompositeData.COMPOSITE_TYPE), ArrayType.getArrayType(ProgressInfoCompositeData.COMPOSITE_TYPE)};
            COMPOSITE_TYPE = new CompositeType(SessionInfo.class.getName(), "SessionInfo", ITEM_NAMES, ITEM_DESCS, ITEM_TYPES);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

