/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.MD5Digest;
import org.jboss.netty.buffer.ChannelBuffer;

public abstract class ResultMessage
extends Message.Response {
    public static final Message.Codec<ResultMessage> codec = new Message.Codec<ResultMessage>(){

        @Override
        public ResultMessage decode(ChannelBuffer body, int version) {
            Kind kind = Kind.fromId(body.readInt());
            return (ResultMessage)kind.subcodec.decode(body, version);
        }

        @Override
        public void encode(ResultMessage msg, ChannelBuffer dest, int version) {
            dest.writeInt(msg.kind.id);
            msg.kind.subcodec.encode(msg, dest, version);
        }

        @Override
        public int encodedSize(ResultMessage msg, int version) {
            return 4 + msg.kind.subcodec.encodedSize(msg, version);
        }
    };
    public final Kind kind;

    protected ResultMessage(Kind kind) {
        super(Message.Type.RESULT);
        this.kind = kind;
    }

    public abstract CqlResult toThriftResult();

    public static class SchemaChange
    extends ResultMessage {
        public final Change change;
        public final String keyspace;
        public final String columnFamily;
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body, int version) {
                Change change = CBUtil.readEnumValue(Change.class, body);
                String keyspace = CBUtil.readString(body);
                String columnFamily = CBUtil.readString(body);
                return new SchemaChange(change, keyspace, columnFamily);
            }

            @Override
            public void encode(ResultMessage msg, ChannelBuffer dest, int version) {
                assert (msg instanceof SchemaChange);
                SchemaChange scm = (SchemaChange)msg;
                CBUtil.writeEnumValue(scm.change, dest);
                CBUtil.writeString(scm.keyspace, dest);
                CBUtil.writeString(scm.columnFamily, dest);
            }

            @Override
            public int encodedSize(ResultMessage msg, int version) {
                assert (msg instanceof SchemaChange);
                SchemaChange scm = (SchemaChange)msg;
                int size = 0;
                size += CBUtil.sizeOfEnumValue(scm.change);
                size += CBUtil.sizeOfString(scm.keyspace);
                return size += CBUtil.sizeOfString(scm.columnFamily);
            }
        };

        public SchemaChange(Change change, String keyspace) {
            this(change, keyspace, "");
        }

        public SchemaChange(Change change, String keyspace, String columnFamily) {
            super(Kind.SCHEMA_CHANGE);
            this.change = change;
            this.keyspace = keyspace;
            this.columnFamily = columnFamily;
        }

        @Override
        public CqlResult toThriftResult() {
            return new CqlResult(CqlResultType.VOID);
        }

        public String toString() {
            return "RESULT schema change " + (Object)((Object)this.change) + " on " + this.keyspace + (this.columnFamily.isEmpty() ? "" : "." + this.columnFamily);
        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class Prepared
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body, int version) {
                MD5Digest id = MD5Digest.wrap(CBUtil.readBytes(body));
                ResultSet.Metadata metadata = ResultSet.Metadata.codec.decode(body, version);
                ResultSet.Metadata resultMetadata = ResultSet.Metadata.EMPTY;
                if (version > 1) {
                    resultMetadata = ResultSet.Metadata.codec.decode(body, version);
                }
                return new Prepared(id, -1, metadata, resultMetadata);
            }

            @Override
            public void encode(ResultMessage msg, ChannelBuffer dest, int version) {
                assert (msg instanceof Prepared);
                Prepared prepared = (Prepared)msg;
                assert (prepared.statementId != null);
                CBUtil.writeBytes(prepared.statementId.bytes, dest);
                ResultSet.Metadata.codec.encode(prepared.metadata, dest, version);
                if (version > 1) {
                    ResultSet.Metadata.codec.encode(prepared.resultMetadata, dest, version);
                }
            }

            @Override
            public int encodedSize(ResultMessage msg, int version) {
                assert (msg instanceof Prepared);
                Prepared prepared = (Prepared)msg;
                assert (prepared.statementId != null);
                int size = 0;
                size += CBUtil.sizeOfBytes(prepared.statementId.bytes);
                size += ResultSet.Metadata.codec.encodedSize(prepared.metadata, version);
                if (version > 1) {
                    size += ResultSet.Metadata.codec.encodedSize(prepared.resultMetadata, version);
                }
                return size;
            }
        };
        public final MD5Digest statementId;
        public final ResultSet.Metadata metadata;
        public final ResultSet.Metadata resultMetadata;
        private final int thriftStatementId;

        public Prepared(MD5Digest statementId, ParsedStatement.Prepared prepared) {
            this(statementId, -1, new ResultSet.Metadata(prepared.boundNames), Prepared.extractResultMetadata(prepared.statement));
        }

        public static Prepared forThrift(int statementId, List<ColumnSpecification> names) {
            return new Prepared(null, statementId, new ResultSet.Metadata(names), ResultSet.Metadata.EMPTY);
        }

        private Prepared(MD5Digest statementId, int thriftStatementId, ResultSet.Metadata metadata, ResultSet.Metadata resultMetadata) {
            super(Kind.PREPARED);
            this.statementId = statementId;
            this.thriftStatementId = thriftStatementId;
            this.metadata = metadata;
            this.resultMetadata = resultMetadata;
        }

        private static ResultSet.Metadata extractResultMetadata(CQLStatement statement) {
            if (!(statement instanceof SelectStatement)) {
                return ResultSet.Metadata.EMPTY;
            }
            return ((SelectStatement)statement).getResultMetadata();
        }

        @Override
        public CqlResult toThriftResult() {
            throw new UnsupportedOperationException();
        }

        public CqlPreparedResult toThriftPreparedResult() {
            ArrayList<String> namesString = new ArrayList<String>(this.metadata.names.size());
            ArrayList<String> typesString = new ArrayList<String>(this.metadata.names.size());
            for (ColumnSpecification name : this.metadata.names) {
                namesString.add(name.toString());
                typesString.add(name.type.toString());
            }
            return new CqlPreparedResult(this.thriftStatementId, this.metadata.names.size()).setVariable_types(typesString).setVariable_names(namesString);
        }

        public String toString() {
            return "RESULT PREPARED " + this.statementId + " " + this.metadata + " (resultMetadata=" + this.resultMetadata + ")";
        }
    }

    public static class Rows
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body, int version) {
                return new Rows(ResultSet.codec.decode(body, version));
            }

            @Override
            public void encode(ResultMessage msg, ChannelBuffer dest, int version) {
                assert (msg instanceof Rows);
                Rows rowMsg = (Rows)msg;
                ResultSet.codec.encode(rowMsg.result, dest, version);
            }

            @Override
            public int encodedSize(ResultMessage msg, int version) {
                assert (msg instanceof Rows);
                Rows rowMsg = (Rows)msg;
                return ResultSet.codec.encodedSize(rowMsg.result, version);
            }
        };
        public final ResultSet result;

        public Rows(ResultSet result) {
            super(Kind.ROWS);
            this.result = result;
        }

        @Override
        public CqlResult toThriftResult() {
            return this.result.toThriftResult();
        }

        public String toString() {
            return "ROWS " + this.result;
        }
    }

    public static class SetKeyspace
    extends ResultMessage {
        public final String keyspace;
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body, int version) {
                String keyspace = CBUtil.readString(body);
                return new SetKeyspace(keyspace);
            }

            @Override
            public void encode(ResultMessage msg, ChannelBuffer dest, int version) {
                assert (msg instanceof SetKeyspace);
                CBUtil.writeString(((SetKeyspace)msg).keyspace, dest);
            }

            @Override
            public int encodedSize(ResultMessage msg, int version) {
                assert (msg instanceof SetKeyspace);
                return CBUtil.sizeOfString(((SetKeyspace)msg).keyspace);
            }
        };

        public SetKeyspace(String keyspace) {
            super(Kind.SET_KEYSPACE);
            this.keyspace = keyspace;
        }

        @Override
        public CqlResult toThriftResult() {
            return new CqlResult(CqlResultType.VOID);
        }

        public String toString() {
            return "RESULT set keyspace " + this.keyspace;
        }
    }

    public static class Void
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body, int version) {
                return new Void();
            }

            @Override
            public void encode(ResultMessage msg, ChannelBuffer dest, int version) {
                assert (msg instanceof Void);
            }

            @Override
            public int encodedSize(ResultMessage msg, int version) {
                return 0;
            }
        };

        public Void() {
            super(Kind.VOID);
        }

        @Override
        public CqlResult toThriftResult() {
            return new CqlResult(CqlResultType.VOID);
        }

        public String toString() {
            return "EMPTY RESULT";
        }
    }

    public static enum Kind {
        VOID(1, Void.subcodec),
        ROWS(2, Rows.subcodec),
        SET_KEYSPACE(3, SetKeyspace.subcodec),
        PREPARED(4, Prepared.subcodec),
        SCHEMA_CHANGE(5, SchemaChange.subcodec);

        public final int id;
        public final Message.Codec<ResultMessage> subcodec;
        private static final Kind[] ids;

        private Kind(int id, Message.Codec<ResultMessage> subcodec) {
            this.id = id;
            this.subcodec = subcodec;
        }

        public static Kind fromId(int id) {
            Kind k = ids[id];
            if (k == null) {
                throw new ProtocolException(String.format("Unknown kind id %d in RESULT message", id));
            }
            return k;
        }

        static {
            int maxId = -1;
            for (Kind k : Kind.values()) {
                maxId = Math.max(maxId, k.id);
            }
            ids = new Kind[maxId + 1];
            for (Kind k : Kind.values()) {
                if (ids[k.id] != null) {
                    throw new IllegalStateException("Duplicate kind id");
                }
                Kind.ids[k.id] = k;
            }
        }
    }
}

