/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.CollectionSerializer;

public abstract class UserTypes {
    private UserTypes() {
    }

    public static ColumnSpecification fieldSpecOf(ColumnSpecification column, int field) {
        UserType ut = (UserType)column.type;
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier(column.name + "." + (String)UTF8Type.instance.compose(ut.fieldName(field)), true), ut.fieldType(field));
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final UserType type;
        private final List<Term> values;

        public DelayedValue(UserType type, List<Term> values) {
            this.type = type;
            this.values = values;
        }

        @Override
        public boolean containsBindMarker() {
            for (Term t : this.values) {
                if (!t.containsBindMarker()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            for (int i = 0; i < this.type.size(); ++i) {
                this.values.get(i).collectMarkerSpecification(boundNames);
            }
        }

        private ByteBuffer[] bindInternal(QueryOptions options) throws InvalidRequestException {
            int version = options.getProtocolVersion();
            ByteBuffer[] buffers = new ByteBuffer[this.values.size()];
            for (int i = 0; i < this.type.size(); ++i) {
                buffers[i] = this.values.get(i).bindAndGet(options);
                if (version >= 3 || !this.type.fieldType(i).isCollection() || buffers[i] == null) continue;
                buffers[i] = ((CollectionSerializer)((CollectionType)this.type.fieldType(i)).getSerializer()).reserializeToV3(buffers[i]);
            }
            return buffers;
        }

        @Override
        public Constants.Value bind(QueryOptions options) throws InvalidRequestException {
            return new Constants.Value(this.bindAndGet(options));
        }

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            return UserType.buildValue(this.bindInternal(options));
        }
    }

    public static class Literal
    implements Term.Raw {
        public final Map<ColumnIdentifier, Term.Raw> entries;

        public Literal(Map<ColumnIdentifier, Term.Raw> entries) {
            this.entries = entries;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            UserType ut = (UserType)receiver.type;
            boolean allTerminal = true;
            ArrayList<Term> values = new ArrayList<Term>(this.entries.size());
            int foundValues = 0;
            for (int i = 0; i < ut.size(); ++i) {
                ColumnIdentifier field = new ColumnIdentifier(ut.fieldName(i), UTF8Type.instance);
                Term.Raw raw = this.entries.get(field);
                if (raw == null) {
                    raw = Constants.NULL_LITERAL;
                } else {
                    ++foundValues;
                }
                Term value = raw.prepare(keyspace, UserTypes.fieldSpecOf(receiver, i));
                if (value instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(value);
            }
            if (foundValues != this.entries.size()) {
                for (ColumnIdentifier id : this.entries.keySet()) {
                    if (ut.fieldNames().contains(id.bytes)) continue;
                    throw new InvalidRequestException(String.format("Unknown field '%s' in value of user defined type %s", id, ut.getNameAsString()));
                }
            }
            DelayedValue value = new DelayedValue((UserType)receiver.type, values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof UserType)) {
                throw new InvalidRequestException(String.format("Invalid user type literal for %s of type %s", receiver, receiver.type.asCQL3Type()));
            }
            UserType ut = (UserType)receiver.type;
            for (int i = 0; i < ut.size(); ++i) {
                ColumnSpecification fieldSpec;
                ColumnIdentifier field = new ColumnIdentifier(ut.fieldName(i), UTF8Type.instance);
                Term.Raw value = this.entries.get(field);
                if (value == null || value.testAssignment(keyspace, fieldSpec = UserTypes.fieldSpecOf(receiver, i)).isAssignable()) continue;
                throw new InvalidRequestException(String.format("Invalid user type literal for %s: field %s is not of type %s", receiver, field, fieldSpec.type.asCQL3Type()));
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            try {
                this.validateAssignableTo(keyspace, receiver);
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            catch (InvalidRequestException e) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            Iterator<Map.Entry<ColumnIdentifier, Term.Raw>> iter = this.entries.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<ColumnIdentifier, Term.Raw> entry = iter.next();
                sb.append(entry.getKey()).append(":").append(entry.getValue());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

