/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaSourceUDFFactory {
    private static final String GENERATED_CODE_PACKAGE = "org.apache.cassandra.cql3.udf.gen.";
    protected static final Logger logger = LoggerFactory.getLogger(JavaSourceUDFFactory.class);
    private static final AtomicInteger classSequence = new AtomicInteger();

    static UDFunction buildUDF(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, String body, boolean deterministic) throws InvalidRequestException {
        Class<?> javaReturnType = UDFunction.javaType(returnType);
        Class<?>[] javaParamTypes = UDFunction.javaParamTypes(argTypes);
        String clsName = JavaSourceUDFFactory.generateClassName(name);
        String codeCtor = JavaSourceUDFFactory.generateConstructor(clsName);
        String codeExec = JavaSourceUDFFactory.generateExecuteMethod(argNames, javaParamTypes);
        String codeExecInt = JavaSourceUDFFactory.generateExecuteInternalMethod(argNames, body, javaReturnType, javaParamTypes);
        if (logger.isDebugEnabled()) {
            logger.debug("Generating java source UDF for {} with following c'tor and functions:\n{}\n{}\n{}", new Object[]{name, codeCtor, codeExecInt, codeExec});
        }
        try {
            ClassPool classPool = ClassPool.getDefault();
            CtClass base = classPool.get(UDFunction.class.getName());
            CtClass cc = classPool.makeClass(GENERATED_CODE_PACKAGE + clsName, base);
            cc.setModifiers(cc.getModifiers() | 0x10);
            cc.addConstructor(CtNewConstructor.make((String)codeCtor, (CtClass)cc));
            cc.addMethod(CtNewMethod.make((String)codeExecInt, (CtClass)cc));
            cc.addMethod(CtNewMethod.make((String)codeExec, (CtClass)cc));
            Constructor ctor = cc.toClass().getDeclaredConstructor(FunctionName.class, List.class, List.class, AbstractType.class, String.class, Boolean.TYPE);
            return (UDFunction)ctor.newInstance(name, argNames, argTypes, returnType, body, deterministic);
        }
        catch (IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException | CannotCompileException | NotFoundException e) {
            throw new InvalidRequestException(String.format("Could not compile function '%s' from Java source: %s", name, e));
        }
        catch (InvocationTargetException e) {
            throw new InvalidRequestException(String.format("Could not compile function '%s' from Java source: %s", name, e.getCause()));
        }
    }

    private static String generateClassName(FunctionName name) {
        String qualifiedName = name.toString();
        StringBuilder sb = new StringBuilder(qualifiedName.length() + 10);
        sb.append('C');
        for (int i = 0; i < qualifiedName.length(); ++i) {
            char c = qualifiedName.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            sb.append(c);
        }
        sb.append('_');
        sb.append(classSequence.incrementAndGet());
        return sb.toString();
    }

    private static String generateConstructor(String clsName) {
        return "public " + clsName + "(org.apache.cassandra.cql3.functions.FunctionName name, " + "java.util.List argNames, " + "java.util.List argTypes, " + "org.apache.cassandra.db.marshal.AbstractType returnType, " + "String body," + "boolean deterministic)\n{" + "  super(name, argNames, argTypes, returnType, \"java\", body, deterministic);\n" + "}";
    }

    private static String generateExecuteInternalMethod(List<ColumnIdentifier> argNames, String body, Class<?> returnType, Class<?>[] paramTypes) {
        StringBuilder codeInt = new StringBuilder(64 + 32 * paramTypes.length + body.length());
        codeInt.append("private ").append(returnType.getName()).append(" executeInternal(");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                codeInt.append(", ");
            }
            codeInt.append(paramTypes[i].getName()).append(' ').append(argNames.get(i));
        }
        codeInt.append(")\n{").append(body).append('}');
        return codeInt.toString();
    }

    private static String generateExecuteMethod(List<ColumnIdentifier> argNames, Class<?>[] paramTypes) {
        StringBuilder code = new StringBuilder(1024);
        code.append("public java.nio.ByteBuffer execute(java.util.List params)\nthrows org.apache.cassandra.exceptions.InvalidRequestException\n{\n  try\n  {\n    Object result = executeInternal(");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                code.append(',');
            }
            if (logger.isDebugEnabled()) {
                code.append("\n      /* ").append(argNames.get(i)).append(" */ ");
            }
            code.append("\n      (").append(paramTypes[i].getName()).append(")").append("org.apache.cassandra.cql3.functions.JavaSourceUDFFactory.compose(argTypes, params, ").append(i).append(')');
        }
        code.append("\n    );\n    return result != null ? returnType.decompose(result) : null;\n  }\n  catch (Throwable t)\n  {\n    logger.error(\"Invocation of function '{}' failed\", this, t);\n    if (t instanceof VirtualMachineError)\n      throw (VirtualMachineError)t;\n    throw new org.apache.cassandra.exceptions.InvalidRequestException(\"Invocation of function '\" + this + \"' failed: \" + t);\n  }\n}");
        return code.toString();
    }

    public static Object compose(List<AbstractType<?>> argTypes, List<ByteBuffer> parameters, int param) {
        ByteBuffer bb = parameters.get(param);
        return bb == null ? null : argTypes.get(param).compose(bb);
    }
}

