/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.JavaSourceUDFFactory;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.ScriptBasedUDF;
import org.apache.cassandra.db.CFRowAdder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UDFunction
extends AbstractFunction
implements ScalarFunction {
    protected static final Logger logger = LoggerFactory.getLogger(UDFunction.class);
    protected final List<ColumnIdentifier> argNames;
    protected final String language;
    protected final String body;
    private final boolean deterministic;

    protected UDFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, String language, String body, boolean deterministic) {
        super(name, argTypes, returnType);
        assert (new HashSet<ColumnIdentifier>(argNames).size() == argNames.size()) : "duplicate argument names";
        this.argNames = argNames;
        this.language = language;
        this.body = body;
        this.deterministic = deterministic;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public static UDFunction create(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, String language, String body, boolean deterministic) throws InvalidRequestException {
        switch (language) {
            case "java": {
                return JavaSourceUDFFactory.buildUDF(name, argNames, argTypes, returnType, body, deterministic);
            }
        }
        return new ScriptBasedUDF(name, argNames, argTypes, returnType, language, body, deterministic);
    }

    static Class<?>[] javaParamTypes(List<AbstractType<?>> argTypes) {
        Class[] paramTypes = new Class[argTypes.size()];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = UDFunction.javaType(argTypes.get(i));
        }
        return paramTypes;
    }

    static Class<?> javaType(AbstractType<?> type) {
        return type.getSerializer().getType();
    }

    private static UDFunction createBrokenFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, String language, String body, final InvalidRequestException reason) {
        return new UDFunction(name, argNames, argTypes, returnType, language, body, true){

            @Override
            public ByteBuffer execute(List<ByteBuffer> parameters) throws InvalidRequestException {
                throw new InvalidRequestException(String.format("Function '%s' exists but hasn't been loaded successfully for the following reason: %s. Please see the server log for more details", this, reason.getMessage()));
            }
        };
    }

    private static ByteBuffer computeSignature(List<AbstractType<?>> argTypes) {
        MessageDigest digest = FBUtilities.newMessageDigest("SHA-1");
        for (AbstractType<?> type : argTypes) {
            digest.update(type.toString().getBytes(StandardCharsets.UTF_8));
        }
        return ByteBuffer.wrap(digest.digest());
    }

    @Override
    public boolean isPure() {
        return this.deterministic;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    private static Mutation makeSchemaMutation(FunctionName name) {
        CompositeType kv = (CompositeType)CFMetaData.SchemaFunctionsCf.getKeyValidator();
        return new Mutation("system", kv.decompose(name.namespace, name.name));
    }

    public Mutation toSchemaDrop(long timestamp) {
        Mutation mutation = UDFunction.makeSchemaMutation(this.name);
        ColumnFamily cf = mutation.addOrGet("schema_functions");
        Composite prefix = CFMetaData.SchemaFunctionsCf.comparator.make(UDFunction.computeSignature(this.argTypes));
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addAtom(new RangeTombstone(prefix, prefix.end(), timestamp, ldt));
        return mutation;
    }

    public Mutation toSchemaUpdate(long timestamp) {
        Mutation mutation = UDFunction.makeSchemaMutation(this.name);
        ColumnFamily cf = mutation.addOrGet("schema_functions");
        Composite prefix = CFMetaData.SchemaFunctionsCf.comparator.make(UDFunction.computeSignature(this.argTypes));
        CFRowAdder adder = new CFRowAdder(cf, prefix, timestamp);
        adder.resetCollection("argument_names");
        adder.resetCollection("argument_types");
        adder.add("return_type", this.returnType.toString());
        adder.add("language", this.language);
        adder.add("body", this.body);
        adder.add("deterministic", this.deterministic);
        for (int i = 0; i < this.argNames.size(); ++i) {
            adder.addListEntry("argument_names", this.argNames.get((int)i).bytes);
            adder.addListEntry("argument_types", ((AbstractType)this.argTypes.get(i)).toString());
        }
        return mutation;
    }

    public static UDFunction fromSchema(UntypedResultSet.Row row) {
        List<AbstractType<?>> argTypes;
        List<ColumnIdentifier> argNames;
        String namespace = row.getString("namespace");
        String fname = row.getString("name");
        FunctionName name = new FunctionName(namespace, fname);
        List<String> names = row.getList("argument_names", UTF8Type.instance);
        List<String> types = row.getList("argument_types", UTF8Type.instance);
        if (names == null) {
            argNames = Collections.emptyList();
        } else {
            argNames = new ArrayList(names.size());
            for (String arg : names) {
                argNames.add(new ColumnIdentifier(arg, true));
            }
        }
        if (types == null) {
            argTypes = Collections.emptyList();
        } else {
            argTypes = new ArrayList(types.size());
            for (String type : types) {
                argTypes.add(UDFunction.parseType(type));
            }
        }
        AbstractType<?> returnType = UDFunction.parseType(row.getString("return_type"));
        boolean deterministic = row.getBoolean("deterministic");
        String language = row.getString("language");
        String body = row.getString("body");
        try {
            return UDFunction.create(name, argNames, argTypes, returnType, language, body, deterministic);
        }
        catch (InvalidRequestException e) {
            logger.error(String.format("Cannot load function '%s' from schema: this function won't be available (on this node)", name), (Throwable)e);
            return UDFunction.createBrokenFunction(name, argNames, argTypes, returnType, language, body, e);
        }
    }

    private static AbstractType<?> parseType(String str) {
        try {
            return TypeParser.parse(str);
        }
        catch (ConfigurationException | SyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<ByteBuffer, UDFunction> fromSchema(Row row) {
        UntypedResultSet results = QueryProcessor.resultify("SELECT * FROM system.schema_functions", row);
        HashMap<ByteBuffer, UDFunction> udfs = new HashMap<ByteBuffer, UDFunction>(results.size());
        for (UntypedResultSet.Row result : results) {
            udfs.put(result.getBlob("signature"), UDFunction.fromSchema(result));
        }
        return udfs;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UDFunction)) {
            return false;
        }
        UDFunction that = (UDFunction)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.argNames, that.argNames) && Objects.equal((Object)this.argTypes, (Object)that.argTypes) && Objects.equal((Object)this.returnType, (Object)that.returnType) && Objects.equal((Object)this.language, (Object)that.language) && Objects.equal((Object)this.body, (Object)that.body) && Objects.equal((Object)this.deterministic, (Object)that.deterministic);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.argNames, this.argTypes, this.returnType, this.language, this.body, this.deterministic});
    }
}

