/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.AggregateFunctionSelector;
import org.apache.cassandra.cql3.selection.ScalarFunctionSelector;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.commons.lang3.text.StrBuilder;

abstract class AbstractFunctionSelector<T extends Function>
extends Selector {
    protected final T fun;
    protected final List<ByteBuffer> args;
    protected final List<Selector> argSelectors;

    public static Selector.Factory newFactory(final Function fun, final SelectorFactories factories) throws InvalidRequestException {
        if (fun.isAggregate()) {
            if (factories.doesAggregation()) {
                throw new InvalidRequestException("aggregate functions cannot be used as arguments of aggregate functions");
            }
        } else if (factories.doesAggregation() && !factories.containsOnlyAggregateFunctions()) {
            throw new InvalidRequestException(String.format("the %s function arguments must be either all aggregates or all none aggregates", fun.name().name));
        }
        return new Selector.Factory(){

            @Override
            public ColumnSpecification getColumnSpecification(CFMetaData cfm) {
                return new ColumnSpecification(cfm.ksName, cfm.cfName, new ColumnIdentifier(fun.toString(), true), fun.returnType());
            }

            @Override
            public Selector newInstance() {
                return fun.isAggregate() ? new AggregateFunctionSelector(fun, factories.newInstances()) : new ScalarFunctionSelector(fun, factories.newInstances());
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                return factories.containsWritetimeSelectorFactory();
            }

            @Override
            public boolean isTTLSelectorFactory() {
                return factories.containsTTLSelectorFactory();
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                return fun.isAggregate() || factories.containsOnlyAggregateFunctions();
            }
        };
    }

    protected AbstractFunctionSelector(T fun, List<Selector> argSelectors) {
        this.fun = fun;
        this.argSelectors = argSelectors;
        this.args = Arrays.asList(new ByteBuffer[argSelectors.size()]);
    }

    @Override
    public AbstractType<?> getType() {
        return this.fun.returnType();
    }

    public String toString() {
        return new StrBuilder().append((Object)this.fun.name()).append("(").appendWithSeparators(this.argSelectors, ", ").append(")").toString();
    }
}

