/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Selection {
    private final Collection<ColumnDefinition> columns;
    private final ResultSet.Metadata metadata;
    private final boolean collectTimestamps;
    private final boolean collectTTLs;

    protected Selection(Collection<ColumnDefinition> columns, List<ColumnSpecification> metadata, boolean collectTimestamps, boolean collectTTLs) {
        this.columns = columns;
        this.metadata = new ResultSet.Metadata(metadata);
        this.collectTimestamps = collectTimestamps;
        this.collectTTLs = collectTTLs;
    }

    public boolean isWildcard() {
        return false;
    }

    public ResultSet.Metadata getResultMetadata() {
        return this.metadata;
    }

    public static Selection wildcard(CFMetaData cfm) {
        ArrayList<ColumnDefinition> all = new ArrayList<ColumnDefinition>(cfm.allColumns().size());
        Iterators.addAll(all, cfm.allColumnsInSelectOrder());
        return new SimpleSelection(all, true);
    }

    public static Selection forColumns(Collection<ColumnDefinition> columns) {
        return new SimpleSelection(columns, false);
    }

    public int addColumnForOrdering(ColumnDefinition c) {
        this.columns.add(c);
        this.metadata.addNonSerializedColumn(c);
        return this.columns.size() - 1;
    }

    private static boolean isUsingFunction(List<RawSelector> rawSelectors) {
        for (RawSelector rawSelector : rawSelectors) {
            if (rawSelector.selectable instanceof ColumnIdentifier) continue;
            return true;
        }
        return false;
    }

    public static Selection fromSelectors(CFMetaData cfm, List<RawSelector> rawSelectors) throws InvalidRequestException {
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>();
        SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(RawSelector.toSelectables(rawSelectors), cfm, defs);
        List<ColumnSpecification> metadata = Selection.collectMetadata(cfm, rawSelectors, factories);
        return Selection.isUsingFunction(rawSelectors) ? new SelectionWithFunctions(defs, metadata, factories) : new SimpleSelection(defs, metadata, false);
    }

    private static List<ColumnSpecification> collectMetadata(CFMetaData cfm, List<RawSelector> rawSelectors, SelectorFactories factories) {
        ArrayList<ColumnSpecification> metadata = new ArrayList<ColumnSpecification>(rawSelectors.size());
        Iterator<RawSelector> iter = rawSelectors.iterator();
        for (Selector.Factory factory : factories) {
            ColumnSpecification colSpec = factory.getColumnSpecification(cfm);
            ColumnIdentifier alias = iter.next().alias;
            metadata.add(alias == null ? colSpec : colSpec.withAlias(alias));
        }
        return metadata;
    }

    protected abstract Selectors newSelectors();

    public Collection<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public ResultSetBuilder resultSetBuilder(long now) {
        return new ResultSetBuilder(now);
    }

    public abstract boolean isAggregate();

    static void validateSelectors(List<Selector> selectors, String messageTemplate, Object ... messageArgs) throws InvalidRequestException {
        int aggregates = 0;
        for (Selector s : selectors) {
            if (!s.isAggregate()) continue;
            ++aggregates;
        }
        if (aggregates != 0 && aggregates != selectors.size()) {
            throw new InvalidRequestException(String.format(messageTemplate, messageArgs));
        }
    }

    private static class SelectionWithFunctions
    extends Selection {
        private final SelectorFactories factories;

        public SelectionWithFunctions(Collection<ColumnDefinition> columns, List<ColumnSpecification> metadata, SelectorFactories factories) throws InvalidRequestException {
            super(columns, metadata, factories.containsWritetimeSelectorFactory(), factories.containsTTLSelectorFactory());
            this.factories = factories;
            if (factories.doesAggregation() && !factories.containsOnlyAggregateFunctions()) {
                throw new InvalidRequestException("the select clause must either contains only aggregates or none");
            }
        }

        @Override
        public boolean isAggregate() {
            return this.factories.containsOnlyAggregateFunctions();
        }

        @Override
        protected Selectors newSelectors() {
            return new Selectors(){
                private final List<Selector> selectors;
                {
                    this.selectors = SelectionWithFunctions.this.factories.newInstances();
                }

                @Override
                public void reset() {
                    int m = this.selectors.size();
                    for (int i = 0; i < m; ++i) {
                        this.selectors.get(i).reset();
                    }
                }

                @Override
                public boolean isAggregate() {
                    return SelectionWithFunctions.this.factories.containsOnlyAggregateFunctions();
                }

                @Override
                public List<ByteBuffer> getOutputRow() throws InvalidRequestException {
                    ArrayList<ByteBuffer> outputRow = new ArrayList<ByteBuffer>(this.selectors.size());
                    int m = this.selectors.size();
                    for (int i = 0; i < m; ++i) {
                        outputRow.add(this.selectors.get(i).getOutput());
                    }
                    return outputRow;
                }

                @Override
                public void addInputRow(ResultSetBuilder rs) throws InvalidRequestException {
                    int m = this.selectors.size();
                    for (int i = 0; i < m; ++i) {
                        this.selectors.get(i).addInput(rs);
                    }
                }
            };
        }
    }

    private static class SimpleSelection
    extends Selection {
        private final boolean isWildcard;

        public SimpleSelection(Collection<ColumnDefinition> columns, boolean isWildcard) {
            this(columns, new ArrayList<ColumnSpecification>(columns), isWildcard);
        }

        public SimpleSelection(Collection<ColumnDefinition> columns, List<ColumnSpecification> metadata, boolean isWildcard) {
            super(columns, metadata, false, false);
            this.isWildcard = isWildcard;
        }

        @Override
        public boolean isWildcard() {
            return this.isWildcard;
        }

        @Override
        public boolean isAggregate() {
            return false;
        }

        @Override
        protected Selectors newSelectors() {
            return new Selectors(){
                private List<ByteBuffer> current;

                @Override
                public void reset() {
                    this.current = null;
                }

                @Override
                public List<ByteBuffer> getOutputRow() {
                    return this.current;
                }

                @Override
                public void addInputRow(ResultSetBuilder rs) throws InvalidRequestException {
                    this.current = rs.current;
                }

                @Override
                public boolean isAggregate() {
                    return false;
                }
            };
        }
    }

    private static interface Selectors {
        public boolean isAggregate();

        public void addInputRow(ResultSetBuilder var1) throws InvalidRequestException;

        public List<ByteBuffer> getOutputRow() throws InvalidRequestException;

        public void reset();
    }

    public class ResultSetBuilder {
        private final ResultSet resultSet;
        private final Selectors selectors;
        List<ByteBuffer> current;
        final long[] timestamps;
        final int[] ttls;
        final long now;

        private ResultSetBuilder(long now) {
            this.resultSet = new ResultSet(Selection.this.getResultMetadata().copy(), new ArrayList<List<ByteBuffer>>());
            this.selectors = Selection.this.newSelectors();
            this.timestamps = Selection.this.collectTimestamps ? new long[Selection.this.columns.size()] : null;
            this.ttls = Selection.this.collectTTLs ? new int[Selection.this.columns.size()] : null;
            this.now = now;
        }

        public void add(ByteBuffer v) {
            this.current.add(v);
        }

        public void add(Cell c) {
            this.current.add(this.isDead(c) ? null : this.value(c));
            if (this.timestamps != null) {
                long l = this.timestamps[this.current.size() - 1] = this.isDead(c) ? Long.MIN_VALUE : c.timestamp();
            }
            if (this.ttls != null) {
                int ttl = -1;
                if (!this.isDead(c) && c instanceof ExpiringCell) {
                    ttl = c.getLocalDeletionTime() - (int)(this.now / 1000L);
                }
                this.ttls[this.current.size() - 1] = ttl;
            }
        }

        private boolean isDead(Cell c) {
            return c == null || !c.isLive(this.now);
        }

        public void newRow() throws InvalidRequestException {
            if (this.current != null) {
                this.selectors.addInputRow(this);
                if (!this.selectors.isAggregate()) {
                    this.resultSet.addRow(this.selectors.getOutputRow());
                    this.selectors.reset();
                }
            }
            this.current = new ArrayList<ByteBuffer>(Selection.this.columns.size());
        }

        public ResultSet build() throws InvalidRequestException {
            if (this.current != null) {
                this.selectors.addInputRow(this);
                this.resultSet.addRow(this.selectors.getOutputRow());
                this.selectors.reset();
                this.current = null;
            }
            return this.resultSet;
        }

        private ByteBuffer value(Cell c) {
            return c instanceof CounterCell ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
        }
    }
}

