/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class Selector
implements AssignmentTestable {
    public abstract void addInput(Selection.ResultSetBuilder var1) throws InvalidRequestException;

    public abstract ByteBuffer getOutput() throws InvalidRequestException;

    public abstract AbstractType<?> getType();

    public boolean isAggregate() {
        return false;
    }

    public abstract void reset();

    @Override
    public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        if (receiver.type.equals(this.getType())) {
            return AssignmentTestable.TestResult.EXACT_MATCH;
        }
        if (receiver.type.isValueCompatibleWith(this.getType())) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
    }

    public static abstract class Factory {
        public abstract ColumnSpecification getColumnSpecification(CFMetaData var1);

        public abstract Selector newInstance();

        public boolean isAggregateSelectorFactory() {
            return false;
        }

        public boolean isWritetimeSelectorFactory() {
            return false;
        }

        public boolean isTTLSelectorFactory() {
            return false;
        }
    }
}

