/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.exceptions.InvalidRequestException;

final class SelectorFactories
implements Iterable<Selector.Factory> {
    private final List<Selector.Factory> factories;
    private boolean containsWritetimeFactory;
    private boolean containsTTLFactory;
    private int numberOfAggregateFactories;

    public static SelectorFactories createFactoriesAndCollectColumnDefinitions(List<Selectable> selectables, CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
        return new SelectorFactories(selectables, cfm, defs);
    }

    private SelectorFactories(List<Selectable> selectables, CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
        this.factories = new ArrayList<Selector.Factory>(selectables.size());
        for (Selectable selectable : selectables) {
            Selector.Factory factory = selectable.newSelectorFactory(cfm, defs);
            this.containsWritetimeFactory |= factory.isWritetimeSelectorFactory();
            this.containsTTLFactory |= factory.isTTLSelectorFactory();
            if (factory.isAggregateSelectorFactory()) {
                ++this.numberOfAggregateFactories;
            }
            this.factories.add(factory);
        }
    }

    public boolean containsOnlyAggregateFunctions() {
        int size = this.factories.size();
        return size != 0 && this.numberOfAggregateFactories == size;
    }

    public boolean doesAggregation() {
        return this.numberOfAggregateFactories > 0;
    }

    public boolean containsWritetimeSelectorFactory() {
        return this.containsWritetimeFactory;
    }

    public boolean containsTTLSelectorFactory() {
        return this.containsTTLFactory;
    }

    public List<Selector> newInstances() {
        ArrayList<Selector> selectors = new ArrayList<Selector>(this.factories.size());
        for (Selector.Factory factory : this.factories) {
            selectors.add(factory.newInstance());
        }
        return selectors;
    }

    @Override
    public Iterator<Selector.Factory> iterator() {
        return this.factories.iterator();
    }
}

