/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.utils.ByteBufferUtil;

final class WritetimeOrTTLSelector
extends Selector {
    private final String columnName;
    private final int idx;
    private final boolean isWritetime;
    private ByteBuffer current;

    public static Selector.Factory newFactory(final String columnName, final int idx, final boolean isWritetime) {
        return new Selector.Factory(){

            @Override
            public ColumnSpecification getColumnSpecification(CFMetaData cfm) {
                String text = String.format("%s(%s)", isWritetime ? "writetime" : "ttl", columnName);
                return new ColumnSpecification(cfm.ksName, cfm.cfName, new ColumnIdentifier(text, true), isWritetime ? LongType.instance : Int32Type.instance);
            }

            @Override
            public Selector newInstance() {
                return new WritetimeOrTTLSelector(columnName, idx, isWritetime);
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                return isWritetime;
            }

            @Override
            public boolean isTTLSelectorFactory() {
                return !isWritetime;
            }
        };
    }

    @Override
    public void addInput(Selection.ResultSetBuilder rs) {
        int ttl;
        long ts;
        this.current = this.isWritetime ? ((ts = rs.timestamps[this.idx]) != Long.MIN_VALUE ? ByteBufferUtil.bytes(ts) : null) : ((ttl = rs.ttls[this.idx]) > 0 ? ByteBufferUtil.bytes(ttl) : null);
    }

    @Override
    public ByteBuffer getOutput() {
        return this.current;
    }

    @Override
    public void reset() {
        this.current = null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.isWritetime ? LongType.instance : Int32Type.instance;
    }

    public String toString() {
        return this.columnName;
    }

    private WritetimeOrTTLSelector(String columnName, int idx, boolean isWritetime) {
        this.columnName = columnName;
        this.idx = idx;
        this.isWritetime = isWritetime;
    }
}

