/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public final class CreateFunctionStatement
extends SchemaAlteringStatement {
    private final boolean orReplace;
    private final boolean ifNotExists;
    private final FunctionName functionName;
    private final String language;
    private final String body;
    private final boolean deterministic;
    private final List<ColumnIdentifier> argNames;
    private final List<CQL3Type.Raw> argRawTypes;
    private final CQL3Type.Raw rawReturnType;

    public CreateFunctionStatement(FunctionName functionName, String language, String body, boolean deterministic, List<ColumnIdentifier> argNames, List<CQL3Type.Raw> argRawTypes, CQL3Type.Raw rawReturnType, boolean orReplace, boolean ifNotExists) {
        this.functionName = functionName;
        this.language = language;
        this.body = body;
        this.deterministic = deterministic;
        this.argNames = argNames;
        this.argRawTypes = argRawTypes;
        this.rawReturnType = rawReturnType;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.hasAllKeyspacesAccess(Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.ifNotExists && this.orReplace) {
            throw new InvalidRequestException("Cannot use both 'OR REPLACE' and 'IF NOT EXISTS' directives");
        }
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return null;
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        if (new HashSet<ColumnIdentifier>(this.argNames).size() != this.argNames.size()) {
            throw new InvalidRequestException(String.format("duplicate argument names for given function %s with argument names %s", this.functionName, this.argNames));
        }
        ArrayList argTypes = new ArrayList(this.argRawTypes.size());
        for (CQL3Type.Raw rawType : this.argRawTypes) {
            argTypes.add(rawType.prepare(null).getType());
        }
        AbstractType<?> returnType = this.rawReturnType.prepare(null).getType();
        Function old = Functions.find(this.functionName, argTypes);
        if (old != null) {
            if (this.ifNotExists) {
                return false;
            }
            if (!this.orReplace) {
                throw new InvalidRequestException(String.format("Function %s already exists", old));
            }
            if (old.isNative()) {
                throw new InvalidRequestException(String.format("Cannot replace native function %s", old));
            }
            if (!old.returnType().isValueCompatibleWith(returnType)) {
                throw new InvalidRequestException(String.format("Cannot replace function %s, the new return type %s is not compatible with the return type %s of existing function", this.functionName, returnType.asCQL3Type(), old.returnType().asCQL3Type()));
            }
        }
        MigrationManager.announceNewFunction(UDFunction.create(this.functionName, this.argNames, argTypes, returnType, this.language, this.body, this.deterministic), isLocalOnly);
        return true;
    }
}

