/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public final class DropFunctionStatement
extends SchemaAlteringStatement {
    private final FunctionName functionName;
    private final boolean ifExists;
    private final List<CQL3Type.Raw> argRawTypes;
    private final boolean argsPresent;

    public DropFunctionStatement(FunctionName functionName, List<CQL3Type.Raw> argRawTypes, boolean argsPresent, boolean ifExists) {
        this.functionName = functionName;
        this.argRawTypes = argRawTypes;
        this.argsPresent = argsPresent;
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.hasAllKeyspacesAccess(Permission.DROP);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return null;
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        Function old;
        List<Function> olds = Functions.find(this.functionName);
        if (!this.argsPresent && olds != null && olds.size() > 1) {
            throw new InvalidRequestException(String.format("'DROP FUNCTION %s' matches multiple function definitions; specify the argument types by issuing a statement like 'DROP FUNCTION %s (type, type, ...)'. Hint: use cqlsh 'DESCRIBE FUNCTION %s' command to find all overloads", this.functionName, this.functionName, this.functionName));
        }
        ArrayList argTypes = new ArrayList(this.argRawTypes.size());
        for (CQL3Type.Raw rawType : this.argRawTypes) {
            argTypes.add(rawType.prepare(null).getType());
        }
        if (this.argsPresent) {
            old = Functions.find(this.functionName, argTypes);
            if (old == null) {
                if (this.ifExists) {
                    return false;
                }
                StringBuilder sb = new StringBuilder();
                for (CQL3Type.Raw rawType : this.argRawTypes) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(rawType);
                }
                throw new InvalidRequestException(String.format("Cannot drop non existing function '%s(%s)'", this.functionName, sb));
            }
        } else {
            if (olds == null || olds.isEmpty()) {
                if (this.ifExists) {
                    return false;
                }
                throw new InvalidRequestException(String.format("Cannot drop non existing function '%s'", this.functionName));
            }
            old = olds.get(0);
        }
        if (old.isNative()) {
            throw new InvalidRequestException(String.format("Cannot drop function '%s' because it is a native (built-in) function", this.functionName));
        }
        MigrationManager.announceFunctionDrop((UDFunction)old, isLocalOnly);
        return true;
    }
}

