/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.io.sstable.format.Version;

public class AtomDeserializer {
    private final CellNameType type;
    private final CellNameType.Deserializer nameDeserializer;
    private final DataInput in;
    private final ColumnSerializer.Flag flag;
    private final int expireBefore;
    private final Version version;

    public AtomDeserializer(CellNameType type, DataInput in, ColumnSerializer.Flag flag, int expireBefore, Version version) {
        this.type = type;
        this.nameDeserializer = type.newDeserializer(in);
        this.in = in;
        this.flag = flag;
        this.expireBefore = expireBefore;
        this.version = version;
    }

    public boolean hasNext() throws IOException {
        return this.nameDeserializer.hasNext();
    }

    public boolean hasUnprocessed() throws IOException {
        return this.nameDeserializer.hasUnprocessed();
    }

    public int compareNextTo(Composite composite) throws IOException {
        return this.nameDeserializer.compareNextTo(composite);
    }

    public OnDiskAtom readNext() throws IOException {
        Composite name = this.nameDeserializer.readNext();
        assert (!name.isEmpty());
        int b = this.in.readUnsignedByte();
        if ((b & 0x10) != 0) {
            return this.type.rangeTombstoneSerializer().deserializeBody(this.in, name, this.version);
        }
        return this.type.columnSerializer().deserializeColumnBody(this.in, (CellName)name, b, this.flag, this.expireBefore);
    }

    public void skipNext() throws IOException {
        this.nameDeserializer.skipNext();
        int b = this.in.readUnsignedByte();
        if ((b & 0x10) != 0) {
            this.type.rangeTombstoneSerializer().skipBody(this.in, this.version);
        } else {
            this.type.columnSerializer().skipColumnBody(this.in, b);
        }
    }
}

