/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;

class TruncationSerializer
implements IVersionedSerializer<Truncation> {
    TruncationSerializer() {
    }

    @Override
    public void serialize(Truncation t, DataOutputPlus out, int version) throws IOException {
        out.writeUTF(t.keyspace);
        out.writeUTF(t.columnFamily);
    }

    @Override
    public Truncation deserialize(DataInput in, int version) throws IOException {
        String keyspace = in.readUTF();
        String columnFamily = in.readUTF();
        return new Truncation(keyspace, columnFamily);
    }

    @Override
    public long serializedSize(Truncation truncation, int version) {
        return TypeSizes.NATIVE.sizeof(truncation.keyspace) + TypeSizes.NATIVE.sizeof(truncation.columnFamily);
    }
}

