/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Throwables;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.utils.OutputHandler;

public class Upgrader {
    private final ColumnFamilyStore cfs;
    private final SSTableReader sstable;
    private final Set<SSTableReader> toUpgrade;
    private final File directory;
    private final OperationType compactionType = OperationType.UPGRADE_SSTABLES;
    private final CompactionController controller;
    private final AbstractCompactionStrategy strategy;
    private final long estimatedRows;
    private final OutputHandler outputHandler;

    public Upgrader(ColumnFamilyStore cfs, SSTableReader sstable, OutputHandler outputHandler) {
        this.cfs = cfs;
        this.sstable = sstable;
        this.toUpgrade = new HashSet<SSTableReader>(Collections.singleton(sstable));
        this.outputHandler = outputHandler;
        this.directory = new File(sstable.getFilename()).getParentFile();
        this.controller = new UpgradeController(cfs);
        this.strategy = cfs.getCompactionStrategy();
        long estimatedTotalKeys = Math.max((long)cfs.metadata.getMinIndexInterval(), SSTableReader.getApproximateKeyCount(this.toUpgrade));
        long estimatedSSTables = Math.max(1L, SSTableReader.getTotalBytes(this.toUpgrade) / this.strategy.getMaxSSTableBytes());
        this.estimatedRows = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
    }

    private SSTableWriter createCompactionWriter(long repairedAt) {
        MetadataCollector sstableMetadataCollector = new MetadataCollector(this.cfs.getComparator());
        for (SSTableReader sstable : this.toUpgrade) {
            sstableMetadataCollector.addAncestor(sstable.descriptor.generation);
            for (Integer i : sstable.getAncestors()) {
                if (!new File(sstable.descriptor.withGeneration(i).filenameFor(Component.DATA)).exists()) continue;
                sstableMetadataCollector.addAncestor(i);
            }
            sstableMetadataCollector.sstableLevel(sstable.getSSTableLevel());
        }
        return SSTableWriter.create(Descriptor.fromFilename(this.cfs.getTempSSTablePath(this.directory)), this.estimatedRows, repairedAt, this.cfs.metadata, this.cfs.partitioner, sstableMetadataCollector);
    }

    public void upgrade() {
        this.outputHandler.output("Upgrading " + this.sstable);
        SSTableRewriter writer = new SSTableRewriter(this.cfs, this.toUpgrade, CompactionTask.getMaxDataAge(this.toUpgrade), OperationType.UPGRADE_SSTABLES, true);
        try (AbstractCompactionStrategy.ScannerList scanners = this.strategy.getScanners(this.toUpgrade);){
            Iterator iter = new CompactionIterable(this.compactionType, scanners.scanners, this.controller, DatabaseDescriptor.getSSTableFormat()).iterator();
            writer.switchWriter(this.createCompactionWriter(this.sstable.getSSTableMetadata().repairedAt));
            while (iter.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)iter.next();
                writer.append(row);
            }
            writer.finish();
            this.outputHandler.output("Upgrade of " + this.sstable + " complete.");
        }
        catch (Throwable t) {
            writer.abort();
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            this.controller.close();
        }
    }

    private static class UpgradeController
    extends CompactionController {
        public UpgradeController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MAX_VALUE);
        }

        @Override
        public long maxPurgeableTimestamp(DecoratedKey key) {
            return Long.MIN_VALUE;
        }
    }
}

