/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTableWriter
extends SSTable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableWriter.class);
    protected final long repairedAt;
    protected final long keyCount;
    protected final MetadataCollector metadataCollector;
    protected final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;

    protected SSTableWriter(Descriptor descriptor, long keyCount, long repairedAt, CFMetaData metadata, IPartitioner partitioner, MetadataCollector metadataCollector) {
        super(descriptor, SSTableWriter.components(metadata), metadata, partitioner);
        this.keyCount = keyCount;
        this.repairedAt = repairedAt;
        this.metadataCollector = metadataCollector;
        this.rowIndexEntrySerializer = descriptor.version.getSSTableFormat().getIndexSerializer(metadata);
    }

    public static SSTableWriter create(Descriptor descriptor, Long keyCount, Long repairedAt, CFMetaData metadata, IPartitioner partitioner, MetadataCollector metadataCollector) {
        Factory writerFactory = descriptor.getFormat().getWriterFactory();
        return writerFactory.open(descriptor, keyCount, repairedAt, metadata, partitioner, metadataCollector);
    }

    public static SSTableWriter create(Descriptor descriptor, long keyCount, long repairedAt) {
        return SSTableWriter.create(descriptor, keyCount, repairedAt, 0);
    }

    public static SSTableWriter create(Descriptor descriptor, long keyCount, long repairedAt, int sstableLevel) {
        CFMetaData metadata = Schema.instance.getCFMetaData(descriptor);
        MetadataCollector collector = new MetadataCollector(metadata.comparator).sstableLevel(sstableLevel);
        return SSTableWriter.create(descriptor, keyCount, repairedAt, metadata, DatabaseDescriptor.getPartitioner(), collector);
    }

    public static SSTableWriter create(String filename, long keyCount, long repairedAt, int sstableLevel) {
        return SSTableWriter.create(Descriptor.fromFilename(filename), keyCount, repairedAt, sstableLevel);
    }

    public static SSTableWriter create(String filename, long keyCount, long repairedAt) {
        return SSTableWriter.create(Descriptor.fromFilename(filename), keyCount, repairedAt, 0);
    }

    private static Set<Component> components(CFMetaData metadata) {
        HashSet<Component> components = new HashSet<Component>(Arrays.asList(Component.DATA, Component.PRIMARY_INDEX, Component.STATS, Component.SUMMARY, Component.TOC, Component.DIGEST));
        if (metadata.getBloomFilterFpChance() < 1.0) {
            components.add(Component.FILTER);
        }
        if (metadata.compressionParameters().sstableCompressor != null) {
            components.add(Component.COMPRESSION_INFO);
        } else {
            components.add(Component.CRC);
        }
        return components;
    }

    public abstract void mark();

    public abstract RowIndexEntry append(AbstractCompactedRow var1);

    public abstract void append(DecoratedKey var1, ColumnFamily var2);

    public abstract long appendFromStream(DecoratedKey var1, CFMetaData var2, DataInput var3, Version var4) throws IOException;

    public abstract long getFilePointer();

    public abstract long getOnDiskFilePointer();

    public abstract void isolateReferences();

    public abstract void resetAndTruncate();

    public SSTableReader closeAndOpenReader() {
        return this.closeAndOpenReader(System.currentTimeMillis());
    }

    public SSTableReader closeAndOpenReader(long maxDataAge) {
        return this.closeAndOpenReader(maxDataAge, this.repairedAt);
    }

    public abstract SSTableReader closeAndOpenReader(long var1, long var3);

    public abstract SSTableReader openEarly(long var1);

    public abstract Pair<Descriptor, StatsMetadata> close();

    public static Descriptor rename(Descriptor tmpdesc, Set<Component> components) {
        Descriptor newdesc = tmpdesc.asType(Descriptor.Type.FINAL);
        SSTableWriter.rename(tmpdesc, newdesc, components);
        return newdesc;
    }

    public static void rename(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        for (Component component : Sets.difference(components, (Set)Sets.newHashSet((Object[])new Component[]{Component.DATA, Component.SUMMARY}))) {
            FileUtils.renameWithConfirm(tmpdesc.filenameFor(component), newdesc.filenameFor(component));
        }
        FileUtils.renameWithConfirm(tmpdesc.filenameFor(Component.DATA), newdesc.filenameFor(Component.DATA));
        FileUtils.renameWithOutConfirm(tmpdesc.filenameFor(Component.SUMMARY), newdesc.filenameFor(Component.SUMMARY));
    }

    public void abort() {
        this.abort(true);
    }

    public abstract void abort(boolean var1);

    public static abstract class Factory {
        public abstract SSTableWriter open(Descriptor var1, long var2, long var4, CFMetaData var6, IPartitioner var7, MetadataCollector var8);
    }
}

