/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.AbstractDataInput;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;

public class RandomAccessReader
extends AbstractDataInput
implements FileDataInput {
    public static final long CACHE_FLUSH_INTERVAL_IN_BYTES = (long)Math.pow(2.0, 27.0);
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private final String filePath;
    protected ByteBuffer buffer;
    protected long bufferOffset;
    protected long markedPointer;
    protected final FileChannel channel;
    private final long fileLength;
    protected final PoolingSegmentedFile owner;

    protected RandomAccessReader(File file, int bufferSize, PoolingSegmentedFile owner) throws FileNotFoundException {
        this.owner = owner;
        this.filePath = file.getAbsolutePath();
        try {
            this.channel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new FileNotFoundException(this.filePath);
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        try {
            this.fileLength = this.channel.size();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
        this.buffer = this.allocateBuffer(bufferSize);
        this.buffer.limit(0);
    }

    protected ByteBuffer allocateBuffer(int bufferSize) {
        return ByteBuffer.allocate((int)Math.min(this.fileLength, (long)bufferSize));
    }

    public static RandomAccessReader open(File file, PoolingSegmentedFile owner) {
        return RandomAccessReader.open(file, 65536, owner);
    }

    public static RandomAccessReader open(File file) {
        return RandomAccessReader.open(file, 65536, null);
    }

    @VisibleForTesting
    static RandomAccessReader open(File file, int bufferSize, PoolingSegmentedFile owner) {
        try {
            return new RandomAccessReader(file, bufferSize, owner);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static RandomAccessReader open(SequentialWriter writer) {
        return RandomAccessReader.open(new File(writer.getPath()), 65536, null);
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    protected void reBuffer() {
        this.bufferOffset += (long)this.buffer.position();
        this.buffer.clear();
        assert (this.bufferOffset < this.fileLength);
        try {
            int n;
            this.channel.position(this.bufferOffset);
            while (this.buffer.hasRemaining() && (n = this.channel.read(this.buffer)) >= 0) {
            }
            this.buffer.flip();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    @Override
    public long getFilePointer() {
        return this.current();
    }

    protected long current() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    public int getTotalBufferSize() {
        ByteBuffer ref = this.buffer;
        return ref != null ? ref.capacity() : 0;
    }

    @Override
    public void reset() {
        this.seek(this.markedPointer);
    }

    public long bytesPastMark() {
        long bytes = this.current() - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public FileMark mark() {
        this.markedPointer = this.current();
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current() - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() {
        return this.getFilePointer() == this.length();
    }

    @Override
    public long bytesRemaining() {
        return this.length() - this.getFilePointer();
    }

    @Override
    public void close() {
        if (this.owner == null || this.buffer == null) {
            this.deallocate();
        } else {
            this.owner.recycle(this);
        }
    }

    public void deallocate() {
        this.bufferOffset += (long)this.buffer.position();
        this.buffer = null;
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "filePath='" + this.filePath + "')";
    }

    @Override
    public void seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (newPosition >= this.length()) {
            if (newPosition > this.length()) {
                throw new IllegalArgumentException(String.format("unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
            }
            this.buffer.limit(0);
            this.bufferOffset = newPosition;
            return;
        }
        if (newPosition >= this.bufferOffset && newPosition < this.bufferOffset + (long)this.buffer.limit()) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
            return;
        }
        this.bufferOffset = newPosition;
        this.buffer.clear();
        this.reBuffer();
        assert (this.current() == newPosition);
    }

    @Override
    public int read() {
        if (this.buffer == null) {
            throw new AssertionError((Object)"Attempted to read from closed RAR");
        }
        if (this.isEOF()) {
            return -1;
        }
        if (!this.buffer.hasRemaining()) {
            this.reBuffer();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buff, int offset, int length) {
        if (this.buffer == null) {
            throw new AssertionError((Object)"Attempted to read from closed RAR");
        }
        if (length == 0) {
            return 0;
        }
        if (this.isEOF()) {
            return -1;
        }
        if (!this.buffer.hasRemaining()) {
            this.reBuffer();
        }
        int toCopy = Math.min(length, this.buffer.remaining());
        this.buffer.get(buff, offset, toCopy);
        return toCopy;
    }

    @Override
    public ByteBuffer readBytes(int length) throws EOFException {
        assert (length >= 0) : "buffer length should not be negative: " + length;
        try {
            ByteBuffer result = ByteBuffer.allocate(length);
            while (result.hasRemaining()) {
                if (this.isEOF()) {
                    throw new EOFException();
                }
                if (!this.buffer.hasRemaining()) {
                    this.reBuffer();
                }
                ByteBufferUtil.put(this.buffer, result);
            }
            result.flip();
            return result;
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    public long length() {
        return this.fileLength;
    }

    @Override
    public long getPosition() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    @Override
    public long getPositionLimit() {
        return this.length();
    }

    protected static class BufferedRandomAccessFileMark
    implements FileMark {
        final long pointer;

        public BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

