/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.messages.StreamInitMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingStreamingConnection
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IncomingStreamingConnection.class);
    private final int version;
    private final Socket socket;

    public IncomingStreamingConnection(int version, Socket socket) {
        super("STREAM-INIT-" + socket.getRemoteSocketAddress());
        this.version = version;
        this.socket = socket;
    }

    @Override
    public void run() {
        try {
            if (this.version != 3) {
                throw new IOException(String.format("Received stream using protocol version %d (my version %d). Terminating connection", this.version, 9));
            }
            DataInputStream input = new DataInputStream(this.socket.getInputStream());
            StreamInitMessage init = StreamInitMessage.serializer.deserialize(input, this.version);
            StreamResultFuture.initReceivingSide(init.sessionIndex, init.planId, init.description, init.from, this.socket, init.isForOutgoing, this.version, init.keepSSTableLevel);
        }
        catch (IOException e) {
            logger.debug("IOException reading from socket; closing", (Throwable)e);
            try {
                this.socket.close();
            }
            catch (IOException e2) {
                logger.debug("error closing socket", (Throwable)e2);
            }
        }
    }
}

