/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.repair.LocalSyncTask;
import org.apache.cassandra.repair.NodePair;
import org.apache.cassandra.repair.RemoteSyncTask;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairResult;
import org.apache.cassandra.repair.RepairSession;
import org.apache.cassandra.repair.SnapshotTask;
import org.apache.cassandra.repair.SyncStat;
import org.apache.cassandra.repair.SyncTask;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.ValidationTask;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairJob
extends AbstractFuture<RepairResult>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(RepairJob.class);
    private final RepairSession session;
    private final RepairJobDesc desc;
    private final boolean isSequential;
    private final long repairedAt;
    private final ListeningExecutorService taskExecutor;

    public RepairJob(RepairSession session, String columnFamily, boolean isSequential, long repairedAt, ListeningExecutorService taskExecutor) {
        this.session = session;
        this.desc = new RepairJobDesc(session.parentRepairSession, session.getId(), session.keyspace, columnFamily, session.getRange());
        this.isSequential = isSequential;
        this.repairedAt = repairedAt;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public void run() {
        ListenableFuture validations;
        ArrayList<InetAddress> allEndpoints = new ArrayList<InetAddress>(this.session.endpoints);
        allEndpoints.add(FBUtilities.getBroadcastAddress());
        if (this.isSequential) {
            ArrayList<SnapshotTask> snapshotTasks = new ArrayList<SnapshotTask>(allEndpoints.size());
            for (InetAddress endpoint : allEndpoints) {
                SnapshotTask snapshotTask = new SnapshotTask(this.desc, endpoint);
                snapshotTasks.add(snapshotTask);
                this.taskExecutor.execute((Runnable)snapshotTask);
            }
            ListenableFuture allSnapshotTasks = Futures.allAsList(snapshotTasks);
            validations = Futures.transform((ListenableFuture)allSnapshotTasks, (AsyncFunction)new AsyncFunction<List<InetAddress>, List<TreeResponse>>(){

                public ListenableFuture<List<TreeResponse>> apply(List<InetAddress> endpoints) throws Exception {
                    return RepairJob.this.sendValidationRequest(endpoints);
                }
            }, (Executor)this.taskExecutor);
        } else {
            validations = this.sendValidationRequest(allEndpoints);
        }
        ListenableFuture syncResults = Futures.transform(validations, (AsyncFunction)new AsyncFunction<List<TreeResponse>, List<SyncStat>>(){

            public ListenableFuture<List<SyncStat>> apply(List<TreeResponse> trees) throws Exception {
                FailureDetector.instance.unregisterFailureDetectionEventListener(RepairJob.this.session);
                InetAddress local = FBUtilities.getLocalAddress();
                ArrayList<LocalSyncTask> syncTasks = new ArrayList<LocalSyncTask>();
                for (int i = 0; i < trees.size() - 1; ++i) {
                    TreeResponse r1 = trees.get(i);
                    for (int j = i + 1; j < trees.size(); ++j) {
                        SyncTask task;
                        TreeResponse r2 = trees.get(j);
                        if (r1.endpoint.equals(local) || r2.endpoint.equals(local)) {
                            task = new LocalSyncTask(RepairJob.this.desc, r1, r2, RepairJob.this.repairedAt);
                        } else {
                            task = new RemoteSyncTask(RepairJob.this.desc, r1, r2);
                            RepairJob.this.session.waitForSync(Pair.create(RepairJob.this.desc, new NodePair(r1.endpoint, r2.endpoint)), (RemoteSyncTask)task);
                        }
                        syncTasks.add((LocalSyncTask)task);
                        RepairJob.this.taskExecutor.submit((Runnable)task);
                    }
                }
                return Futures.allAsList(syncTasks);
            }
        }, (Executor)this.taskExecutor);
        Futures.addCallback((ListenableFuture)syncResults, (FutureCallback)new FutureCallback<List<SyncStat>>(){

            public void onSuccess(List<SyncStat> stats) {
                logger.info(String.format("[repair #%s] %s is fully synced", RepairJob.this.session.getId(), ((RepairJob)RepairJob.this).desc.columnFamily));
                RepairJob.this.set(new RepairResult(RepairJob.this.desc, stats));
            }

            public void onFailure(Throwable t) {
                logger.warn(String.format("[repair #%s] %s sync failed", RepairJob.this.session.getId(), ((RepairJob)RepairJob.this).desc.columnFamily));
                RepairJob.this.setException(t);
            }
        }, (Executor)this.taskExecutor);
        Futures.getUnchecked(validations);
    }

    private ListenableFuture<List<TreeResponse>> sendValidationRequest(Collection<InetAddress> endpoints) {
        logger.info(String.format("[repair #%s] requesting merkle trees for %s (to %s)", this.desc.sessionId, this.desc.columnFamily, endpoints));
        int gcBefore = Keyspace.open(this.desc.keyspace).getColumnFamilyStore(this.desc.columnFamily).gcBefore(System.currentTimeMillis());
        ArrayList<ValidationTask> tasks = new ArrayList<ValidationTask>(endpoints.size());
        for (InetAddress endpoint : endpoints) {
            ValidationTask task = new ValidationTask(this.desc, endpoint, gcBefore);
            tasks.add(task);
            this.session.waitForValidation(Pair.create(this.desc, endpoint), task);
            this.taskExecutor.execute((Runnable)task);
            if (!this.isSequential) continue;
            Futures.getUnchecked((Future)((Object)task));
        }
        return Futures.allAsList(tasks);
    }
}

