/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SemanticVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static final Logger logger = LoggerFactory.getLogger(ClientState.class);
    public static final SemanticVersion DEFAULT_CQL_VERSION = QueryProcessor.CQL_VERSION;
    private static final Set<IResource> READABLE_SYSTEM_RESOURCES = new HashSet<IResource>();
    private static final Set<IResource> PROTECTED_AUTH_RESOURCES = new HashSet<IResource>();
    private volatile AuthenticatedUser user;
    private volatile String keyspace;
    private static final QueryHandler cqlQueryHandler;
    public final boolean isInternal;
    private final SocketAddress remoteAddress;

    private ClientState() {
        this.isInternal = true;
        this.remoteAddress = null;
    }

    protected ClientState(SocketAddress remoteAddress) {
        this.isInternal = false;
        this.remoteAddress = remoteAddress;
        if (!DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
            this.user = AuthenticatedUser.ANONYMOUS_USER;
        }
    }

    public static ClientState forInternalCalls() {
        return new ClientState();
    }

    public static ClientState forExternalCalls(SocketAddress remoteAddress) {
        return new ClientState(remoteAddress);
    }

    public static QueryHandler getCQLQueryHandler() {
        return cqlQueryHandler;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getRawKeyspace() {
        return this.keyspace;
    }

    public String getKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("No keyspace has been specified. USE a keyspace, or explicitly specify keyspace.tablename");
        }
        return this.keyspace;
    }

    public void setKeyspace(String ks) throws InvalidRequestException {
        if (this.user != null && Schema.instance.getKSMetaData(ks) == null) {
            throw new InvalidRequestException("Keyspace '" + ks + "' does not exist");
        }
        this.keyspace = ks;
    }

    public void login(AuthenticatedUser user) throws AuthenticationException {
        if (!user.isAnonymous() && !Auth.isExistingUser(user.getName())) {
            throw new AuthenticationException(String.format("User %s doesn't exist - create it with CREATE USER query first", user.getName()));
        }
        this.user = user;
    }

    public void hasAllKeyspacesAccess(Permission perm) throws UnauthorizedException {
        if (this.isInternal) {
            return;
        }
        this.validateLogin();
        this.ensureHasPermission(perm, DataResource.root());
    }

    public void hasKeyspaceAccess(String keyspace, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.hasAccess(keyspace, perm, DataResource.keyspace(keyspace));
    }

    public void hasColumnFamilyAccess(String keyspace, String columnFamily, Permission perm) throws UnauthorizedException, InvalidRequestException {
        ThriftValidation.validateColumnFamily(keyspace, columnFamily);
        this.hasAccess(keyspace, perm, DataResource.columnFamily(keyspace, columnFamily));
    }

    private void hasAccess(String keyspace, Permission perm, DataResource resource) throws UnauthorizedException, InvalidRequestException {
        ClientState.validateKeyspace(keyspace);
        if (this.isInternal) {
            return;
        }
        this.validateLogin();
        this.preventSystemKSSchemaModification(keyspace, resource, perm);
        if (perm.equals((Object)Permission.SELECT) && READABLE_SYSTEM_RESOURCES.contains(resource)) {
            return;
        }
        if (PROTECTED_AUTH_RESOURCES.contains(resource) && (perm.equals((Object)Permission.CREATE) || perm.equals((Object)Permission.ALTER) || perm.equals((Object)Permission.DROP))) {
            throw new UnauthorizedException(String.format("%s schema is protected", resource));
        }
        this.ensureHasPermission(perm, resource);
    }

    public void ensureHasPermission(Permission perm, IResource resource) throws UnauthorizedException {
        for (IResource iResource : Resources.chain(resource)) {
            if (!this.authorize(iResource).contains((Object)perm)) continue;
            return;
        }
        throw new UnauthorizedException(String.format("User %s has no %s permission on %s or any of its parents", new Object[]{this.user.getName(), perm, resource}));
    }

    private void preventSystemKSSchemaModification(String keyspace, DataResource resource, Permission perm) throws UnauthorizedException {
        if (!(perm.equals((Object)Permission.ALTER) || perm.equals((Object)Permission.DROP) || perm.equals((Object)Permission.CREATE))) {
            return;
        }
        if ("system".equalsIgnoreCase(keyspace)) {
            throw new UnauthorizedException(keyspace + " keyspace is not user-modifiable.");
        }
        HashSet allowAlter = Sets.newHashSet((Object[])new String[]{"system_auth", "system_traces"});
        if (!(!allowAlter.contains(keyspace.toLowerCase()) || resource.isKeyspaceLevel() && perm.equals((Object)Permission.ALTER))) {
            throw new UnauthorizedException(String.format("Cannot %s %s", new Object[]{perm, resource}));
        }
    }

    public void validateLogin() throws UnauthorizedException {
        if (this.user == null) {
            throw new UnauthorizedException("You have not logged in");
        }
    }

    public void ensureNotAnonymous() throws UnauthorizedException {
        this.validateLogin();
        if (this.user.isAnonymous()) {
            throw new UnauthorizedException("You have to be logged in and not anonymous to perform this request");
        }
    }

    public void ensureIsSuper(String message) throws UnauthorizedException {
        if (DatabaseDescriptor.getAuthenticator().requireAuthentication() && (this.user == null || !this.user.isSuper())) {
            throw new UnauthorizedException(message);
        }
    }

    private static void validateKeyspace(String keyspace) throws InvalidRequestException {
        if (keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    public AuthenticatedUser getUser() {
        return this.user;
    }

    public static SemanticVersion[] getCQLSupportedVersion() {
        return new SemanticVersion[]{QueryProcessor.CQL_VERSION};
    }

    private Set<Permission> authorize(IResource resource) {
        if (Auth.permissionsCache == null) {
            return DatabaseDescriptor.getAuthorizer().authorize(this.user, resource);
        }
        try {
            return (Set)Auth.permissionsCache.get(Pair.create(this.user, resource));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (String cf : Iterables.concat(Arrays.asList("local", "peers"), SystemKeyspace.allSchemaCfs)) {
            READABLE_SYSTEM_RESOURCES.add(DataResource.columnFamily("system", cf));
        }
        PROTECTED_AUTH_RESOURCES.addAll(DatabaseDescriptor.getAuthenticator().protectedResources());
        PROTECTED_AUTH_RESOURCES.addAll(DatabaseDescriptor.getAuthorizer().protectedResources());
        QueryHandler handler = QueryProcessor.instance;
        String customHandlerClass = System.getProperty("cassandra.custom_query_handler_class");
        if (customHandlerClass != null) {
            try {
                handler = (QueryHandler)FBUtilities.construct(customHandlerClass, "QueryHandler");
                logger.info("Using {} as query handler for native protocol queries (as requested with -Dcassandra.custom_query_handler_class)", (Object)customHandlerClass);
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
                logger.info("Cannot use class {} as query handler ({}), ignoring by defaulting on normal query handling", (Object)customHandlerClass, (Object)e.getMessage());
            }
        }
        cqlQueryHandler = handler;
    }
}

