/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.util.concurrent.AbstractFuture;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageServiceMBean;

public class RepairRunner
extends AbstractFuture<Boolean>
implements Runnable,
NotificationListener {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final PrintStream out;
    private final StorageServiceMBean ssProxy;
    private final String keyspace;
    private final Map<String, String> options;
    private volatile int cmd;
    private volatile boolean success;

    public RepairRunner(PrintStream out, StorageServiceMBean ssProxy, String keyspace, Map<String, String> options) {
        this.out = out;
        this.ssProxy = ssProxy;
        this.keyspace = keyspace;
        this.options = options;
    }

    @Override
    public void run() {
        this.cmd = this.ssProxy.repairAsync(this.keyspace, this.options);
        if (this.cmd <= 0) {
            String message = String.format("[%s] Nothing to repair for keyspace '%s'", this.format.format(System.currentTimeMillis()), this.keyspace);
            this.out.println(message);
            this.set(true);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("repair".equals(notification.getType())) {
            int[] status = (int[])notification.getUserData();
            assert (status.length == 2);
            if (this.cmd == status[0]) {
                String message = String.format("[%s] %s", this.format.format(notification.getTimeStamp()), notification.getMessage());
                this.out.println(message);
                if (status[1] == ActiveRepairService.Status.SESSION_FAILED.ordinal()) {
                    this.success = false;
                } else if (status[1] == ActiveRepairService.Status.FINISHED.ordinal()) {
                    this.set(this.success);
                }
            }
        } else if ("jmx.remote.connection.notifs.lost".equals(notification.getType())) {
            String message = String.format("[%s] Lost notification. You should check server log for repair status of keyspace %s", this.format.format(notification.getTimeStamp()), this.keyspace);
            this.out.println(message);
        } else if ("jmx.remote.connection.failed".equals(notification.getType()) || "jmx.remote.connection.closed".equals(notification.getType())) {
            String message = String.format("JMX connection closed. You should check server log for repair status of keyspace %s(Subsequent keyspaces are not going to be repaired).", this.keyspace);
            this.setException(new IOException(message));
        }
    }
}

