/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.BufferCounterCell;
import org.apache.cassandra.db.BufferExpiringCell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SuperColumns;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.type.TypeReference;

public class SSTableImport {
    private static final String KEYSPACE_OPTION = "K";
    private static final String COLUMN_FAMILY_OPTION = "c";
    private static final String KEY_COUNT_OPTION = "n";
    private static final String IS_SORTED_OPTION = "s";
    private static final Options options = new Options();
    private static CommandLine cmd;
    private Integer keyCountToImport;
    private final boolean isSorted;
    private static final JsonFactory factory;

    public SSTableImport() {
        this(null, false);
    }

    public SSTableImport(boolean isSorted) {
        this(null, isSorted);
    }

    public SSTableImport(Integer keyCountToImport, boolean isSorted) {
        this.keyCountToImport = keyCountToImport;
        this.isSorted = isSorted;
    }

    private void addColumnsToCF(List<?> row, ColumnFamily cfamily) {
        CFMetaData cfm = cfamily.metadata();
        assert (cfm != null);
        for (Object c : row) {
            CellName cname;
            Composite end;
            JsonColumn<List> col = new JsonColumn<List>((List)c, cfm);
            if (col.isRangeTombstone()) {
                Composite start = cfm.comparator.fromByteBuffer(col.getName());
                end = cfm.comparator.fromByteBuffer(col.getValue());
                cfamily.addAtom(new RangeTombstone(start, end, ((JsonColumn)col).timestamp, ((JsonColumn)col).localExpirationTime));
                continue;
            }
            assert (cfm.isCQL3Table() || col.getName().hasRemaining()) : "Cell name should not be empty";
            CellName cellName = cname = col.getName().hasRemaining() ? cfm.comparator.cellFromByteBuffer(col.getName()) : cfm.comparator.rowMarker(Composites.EMPTY);
            if (col.isExpiring()) {
                cfamily.addColumn(new BufferExpiringCell(cname, col.getValue(), ((JsonColumn)col).timestamp, ((JsonColumn)col).ttl, ((JsonColumn)col).localExpirationTime));
                continue;
            }
            if (col.isCounter()) {
                cfamily.addColumn(new BufferCounterCell(cname, col.getValue(), ((JsonColumn)col).timestamp, ((JsonColumn)col).timestampOfLastDelete));
                continue;
            }
            if (col.isDeleted()) {
                cfamily.addTombstone(cname, col.getValue(), ((JsonColumn)col).timestamp);
                continue;
            }
            if (col.isRangeTombstone()) {
                end = cfm.comparator.cellFromByteBuffer(col.getValue());
                cfamily.addAtom(new RangeTombstone(cname, end, ((JsonColumn)col).timestamp, ((JsonColumn)col).localExpirationTime));
                continue;
            }
            if (cname.isEmpty()) {
                cfamily.addColumn(cfm.comparator.rowMarker(Composites.EMPTY), col.getValue(), ((JsonColumn)col).timestamp);
                continue;
            }
            cfamily.addColumn(cname, col.getValue(), ((JsonColumn)col).timestamp);
        }
    }

    private void parseMeta(Map<?, ?> map, ColumnFamily cf, ByteBuffer superColumnName) {
        if (map.containsKey("deletionInfo")) {
            Map unparsedDeletionInfo = (Map)map.get("deletionInfo");
            Number number = (Number)unparsedDeletionInfo.get("markedForDeleteAt");
            long markedForDeleteAt = number instanceof Long ? ((Long)number).longValue() : number.longValue();
            int localDeletionTime = (Integer)unparsedDeletionInfo.get("localDeletionTime");
            if (superColumnName == null) {
                cf.setDeletionInfo(new DeletionInfo(markedForDeleteAt, localDeletionTime));
            } else {
                cf.addAtom(new RangeTombstone(SuperColumns.startOf(superColumnName), SuperColumns.endOf(superColumnName), markedForDeleteAt, localDeletionTime));
            }
        }
    }

    public int importJson(String jsonFile, String keyspace, String cf, String ssTablePath) throws IOException {
        int importedKeys;
        ArrayBackedSortedColumns columnFamily = ArrayBackedSortedColumns.factory.create(keyspace, cf);
        IPartitioner<?> partitioner = DatabaseDescriptor.getPartitioner();
        int n = importedKeys = this.isSorted ? this.importSorted(jsonFile, columnFamily, ssTablePath, partitioner) : this.importUnsorted(jsonFile, columnFamily, ssTablePath, partitioner);
        if (importedKeys != -1) {
            System.out.printf("%d keys imported successfully.%n", importedKeys);
        }
        return importedKeys;
    }

    private int importUnsorted(String jsonFile, ColumnFamily columnFamily, String ssTablePath, IPartitioner<?> partitioner) throws IOException {
        int importedKeys = 0;
        long start = System.nanoTime();
        JsonParser parser = this.getParser(jsonFile);
        Object[] data = (Object[])parser.readValueAs((TypeReference)new TypeReference<Object[]>(){});
        this.keyCountToImport = this.keyCountToImport == null ? data.length : this.keyCountToImport;
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(ssTablePath), (long)this.keyCountToImport.intValue(), 0L, 0);
        System.out.printf("Importing %s keys...%n", this.keyCountToImport);
        TreeMap<DecoratedKey, Map> decoratedKeys = new TreeMap<DecoratedKey, Map>();
        for (Object row : data) {
            Map rowAsMap = (Map)row;
            decoratedKeys.put(partitioner.decorateKey(this.getKeyValidator(columnFamily).fromString((String)rowAsMap.get("key"))), rowAsMap);
        }
        for (Map.Entry row : decoratedKeys.entrySet()) {
            if (((Map)row.getValue()).containsKey("metadata")) {
                this.parseMeta((Map)((Map)row.getValue()).get("metadata"), columnFamily, null);
            }
            Object columns = ((Map)row.getValue()).get("cells");
            this.addColumnsToCF((List)columns, columnFamily);
            writer.append((DecoratedKey)row.getKey(), columnFamily);
            columnFamily.clear();
            ++importedKeys;
            long current = System.nanoTime();
            if (TimeUnit.NANOSECONDS.toSeconds(current - start) >= 5L) {
                System.out.printf("Currently imported %d keys.%n", importedKeys);
                start = current;
            }
            if (this.keyCountToImport != importedKeys) continue;
            break;
        }
        writer.closeAndOpenReader();
        return importedKeys;
    }

    private int importSorted(String jsonFile, ColumnFamily columnFamily, String ssTablePath, IPartitioner<?> partitioner) throws IOException {
        int importedKeys = 0;
        long start = System.nanoTime();
        JsonParser parser = this.getParser(jsonFile);
        if (this.keyCountToImport == null) {
            this.keyCountToImport = 0;
            System.out.println("Counting keys to import, please wait... (NOTE: to skip this use -n <num_keys>)");
            parser.nextToken();
            while (parser.nextToken() != null) {
                parser.skipChildren();
                if (parser.getCurrentToken() == JsonToken.END_ARRAY) break;
                Integer n = this.keyCountToImport;
                Integer n2 = this.keyCountToImport = Integer.valueOf(this.keyCountToImport + 1);
            }
        }
        System.out.printf("Importing %s keys...%n", this.keyCountToImport);
        parser = this.getParser(jsonFile);
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(ssTablePath), (long)this.keyCountToImport.intValue(), 0L);
        int lineNumber = 1;
        DecoratedKey prevStoredKey = null;
        parser.nextToken();
        while (parser.nextToken() != null) {
            String key = parser.getCurrentName();
            Map row = (Map)parser.readValueAs(new TypeReference<Map<?, ?>>(){});
            DecoratedKey currentKey = partitioner.decorateKey(this.getKeyValidator(columnFamily).fromString((String)row.get("key")));
            if (row.containsKey("metadata")) {
                this.parseMeta((Map)row.get("metadata"), columnFamily, null);
            }
            this.addColumnsToCF((List)row.get("cells"), columnFamily);
            if (prevStoredKey != null && prevStoredKey.compareTo(currentKey) != -1) {
                System.err.printf("Line %d: Key %s is greater than previous, collection is not sorted properly. Aborting import. You might need to delete SSTables manually.%n", lineNumber, key);
                return -1;
            }
            writer.append(currentKey, columnFamily);
            columnFamily.clear();
            prevStoredKey = currentKey;
            ++importedKeys;
            ++lineNumber;
            long current = System.nanoTime();
            if (TimeUnit.NANOSECONDS.toSeconds(current - start) >= 5L) {
                System.out.printf("Currently imported %d keys.%n", importedKeys);
                start = current;
            }
            if (this.keyCountToImport != importedKeys) continue;
            break;
        }
        writer.closeAndOpenReader();
        return importedKeys;
    }

    private AbstractType<?> getKeyValidator(ColumnFamily columnFamily) {
        if ("true".equals(System.getProperty("skip.key.validator", "false"))) {
            return BytesType.instance;
        }
        return columnFamily.metadata().getKeyValidator();
    }

    private JsonParser getParser(String fileName) throws IOException {
        return factory.createJsonParser(new File(fileName));
    }

    public static void main(String[] args) throws ParseException, ConfigurationException {
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            SSTableImport.printProgramUsage();
            System.exit(1);
        }
        if (cmd.getArgs().length != 2) {
            SSTableImport.printProgramUsage();
            System.exit(1);
        }
        String json = cmd.getArgs()[0];
        String ssTable = cmd.getArgs()[1];
        String keyspace = cmd.getOptionValue(KEYSPACE_OPTION);
        String cfamily = cmd.getOptionValue(COLUMN_FAMILY_OPTION);
        Integer keyCountToImport = null;
        boolean isSorted = false;
        if (cmd.hasOption(KEY_COUNT_OPTION)) {
            keyCountToImport = Integer.valueOf(cmd.getOptionValue(KEY_COUNT_OPTION));
        }
        if (cmd.hasOption(IS_SORTED_OPTION)) {
            isSorted = true;
        }
        DatabaseDescriptor.loadSchemas();
        if (Schema.instance.getNonSystemKeyspaces().size() < 1) {
            String msg = "no non-system keyspaces are defined";
            System.err.println(msg);
            throw new ConfigurationException(msg);
        }
        try {
            new SSTableImport(keyCountToImport, isSorted).importJson(json, keyspace, cfamily, ssTable);
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            e.printStackTrace();
            System.err.println("ERROR: " + e.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void printProgramUsage() {
        System.out.printf("Usage: %s -s -K <keyspace> -c <column_family> -n <num_keys> <json> <sstable>%n%n", SSTableImport.class.getName());
        System.out.println("Options:");
        for (Object o : options.getOptions()) {
            Option opt = (Option)o;
            System.out.println("  -" + opt.getOpt() + " - " + opt.getDescription());
        }
    }

    private static ByteBuffer stringAsType(String content, AbstractType<?> type) {
        try {
            return type.fromString(content);
        }
        catch (MarshalException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    static {
        factory = new MappingJsonFactory().configure(JsonParser.Feature.INTERN_FIELD_NAMES, false);
        Option optKeyspace = new Option(KEYSPACE_OPTION, true, "Keyspace name.");
        optKeyspace.setRequired(true);
        options.addOption(optKeyspace);
        Option optColfamily = new Option(COLUMN_FAMILY_OPTION, true, "Table name.");
        optColfamily.setRequired(true);
        options.addOption(optColfamily);
        options.addOption(new Option(KEY_COUNT_OPTION, true, "Number of keys to import (Optional)."));
        options.addOption(new Option(IS_SORTED_OPTION, false, "Assume JSON file as already sorted (e.g. created by sstable2json tool) (Optional)."));
    }

    private static class JsonColumn<T> {
        private ByteBuffer name;
        private ByteBuffer value;
        private long timestamp;
        private String kind;
        private int ttl;
        private int localExpirationTime;
        private long timestampOfLastDelete;

        public JsonColumn(T json, CFMetaData meta) {
            if (json instanceof List) {
                CellNameType comparator = meta.comparator;
                List fields = (List)json;
                assert (fields.size() >= 3) : "Cell definition should have at least 3";
                this.name = SSTableImport.stringAsType((String)fields.get(0), comparator.asAbstractType());
                this.timestamp = (Long)fields.get(2);
                this.kind = "";
                if (fields.size() > 3) {
                    this.kind = (String)fields.get(3);
                    if (this.isExpiring()) {
                        this.ttl = (Integer)fields.get(4);
                        this.localExpirationTime = (Integer)fields.get(5);
                    } else if (this.isCounter()) {
                        this.timestampOfLastDelete = ((Integer)fields.get(4)).intValue();
                    } else if (this.isRangeTombstone()) {
                        this.localExpirationTime = (Integer)fields.get(4);
                    }
                }
                if (this.isDeleted()) {
                    this.value = ByteBufferUtil.bytes((Integer)fields.get(1));
                } else if (this.isRangeTombstone()) {
                    this.value = SSTableImport.stringAsType((String)fields.get(1), comparator.asAbstractType());
                } else {
                    assert (meta.isCQL3Table() || this.name.hasRemaining()) : "Cell name should not be empty";
                    this.value = SSTableImport.stringAsType((String)fields.get(1), meta.getValueValidator(this.name.hasRemaining() ? comparator.cellFromByteBuffer(this.name) : meta.comparator.rowMarker(Composites.EMPTY)));
                }
            }
        }

        public boolean isDeleted() {
            return this.kind.equals("d");
        }

        public boolean isExpiring() {
            return this.kind.equals("e");
        }

        public boolean isCounter() {
            return this.kind.equals(SSTableImport.COLUMN_FAMILY_OPTION);
        }

        public boolean isRangeTombstone() {
            return this.kind.equals("t");
        }

        public ByteBuffer getName() {
            return this.name.duplicate();
        }

        public ByteBuffer getValue() {
            return this.value.duplicate();
        }
    }
}

