/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.utils.JVMStabilityInspector;

public class SSTableLevelResetter {
    public static void main(String[] args) {
        PrintStream out = System.out;
        if (args.length == 0) {
            out.println("This command should be run with Cassandra stopped!");
            out.println("Usage: sstablelevelreset <keyspace> <table>");
            System.exit(1);
        }
        if (!args[0].equals("--really-reset") || args.length != 3) {
            out.println("This command should be run with Cassandra stopped, otherwise you will get very strange behavior");
            out.println("Verify that Cassandra is not running and then execute the command like this:");
            out.println("Usage: sstablelevelreset --really-reset <keyspace> <table>");
            System.exit(1);
        }
        try {
            DatabaseDescriptor.loadSchemas();
            String keyspaceName = args[1];
            String columnfamily = args[2];
            if (Schema.instance.getCFMetaData(keyspaceName, columnfamily) == null) {
                System.err.println("ColumnFamily not found: " + keyspaceName + "/" + columnfamily);
                System.exit(1);
            }
            Keyspace keyspace = Keyspace.openWithoutSSTables(keyspaceName);
            ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(columnfamily);
            boolean foundSSTable = false;
            for (Map.Entry<Descriptor, Set<Component>> sstable : cfs.directories.sstableLister().list().entrySet()) {
                if (!sstable.getValue().contains(Component.STATS)) continue;
                foundSSTable = true;
                Descriptor descriptor = sstable.getKey();
                StatsMetadata metadata = (StatsMetadata)descriptor.getMetadataSerializer().deserialize(descriptor, MetadataType.STATS);
                if (metadata.sstableLevel > 0) {
                    out.println("Changing level from " + metadata.sstableLevel + " to 0 on " + descriptor.filenameFor(Component.DATA));
                    descriptor.getMetadataSerializer().mutateLevel(descriptor, 0);
                    continue;
                }
                out.println("Skipped " + descriptor.filenameFor(Component.DATA) + " since it is already on level 0");
            }
            if (!foundSSTable) {
                out.println("Found no sstables, did you give the correct keyspace/table?");
            }
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            t.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

