/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;

public class SSTableRepairedAtSetter {
    public static void main(String[] args) throws IOException {
        PrintStream out = System.out;
        if (args.length == 0) {
            out.println("This command should be run with Cassandra stopped!");
            out.println("Usage: sstablerepairedset [--is-repaired | --is-unrepaired] [-f <sstable-list> | <sstables>]");
            System.exit(1);
        }
        if (args.length < 3 || !args[0].equals("--really-set") || !args[1].equals("--is-repaired") && !args[1].equals("--is-unrepaired")) {
            out.println("This command should be run with Cassandra stopped, otherwise you will get very strange behavior");
            out.println("Verify that Cassandra is not running and then execute the command like this:");
            out.println("Usage: sstablelevelreset --really-set [--is-repaired | --is-unrepaired] [-f <sstable-list> | <sstables>]");
            System.exit(1);
        }
        boolean setIsRepaired = args[1].equals("--is-repaired");
        List<String> fileNames = args[2].equals("-f") ? Files.readAllLines(Paths.get(args[3], new String[0]), Charset.defaultCharset()) : Arrays.asList(args).subList(2, args.length);
        for (String fname : fileNames) {
            Descriptor descriptor = Descriptor.fromFilename(fname);
            if (descriptor.version.hasRepairedAt()) {
                if (setIsRepaired) {
                    FileTime f = Files.getLastModifiedTime(new File(descriptor.filenameFor(Component.DATA)).toPath(), new LinkOption[0]);
                    descriptor.getMetadataSerializer().mutateRepairedAt(descriptor, f.toMillis());
                    continue;
                }
                descriptor.getMetadataSerializer().mutateRepairedAt(descriptor, 0L);
                continue;
            }
            System.err.println("SSTable " + fname + " does not have repaired property, run upgradesstables");
        }
    }
}

