/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class StartupOptionsBuilder {
    public static final String DRIVER_NAME_KEY = "DRIVER_NAME";
    public static final String DRIVER_VERSION_KEY = "DRIVER_VERSION";
    public static final String DRIVER_BAGGAGE = "DRIVER_BAGGAGE";
    public static final String APPLICATION_NAME_KEY = "APPLICATION_NAME";
    public static final String APPLICATION_VERSION_KEY = "APPLICATION_VERSION";
    public static final String CLIENT_ID_KEY = "CLIENT_ID";
    private static final Logger LOG = LoggerFactory.getLogger(StartupOptionsBuilder.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    protected final InternalDriverContext context;
    private UUID clientId;
    private String applicationName;
    private String applicationVersion;

    public StartupOptionsBuilder(InternalDriverContext context) {
        this.context = context;
    }

    public StartupOptionsBuilder withClientId(@Nullable UUID clientId) {
        this.clientId = clientId;
        return this;
    }

    public StartupOptionsBuilder withApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public StartupOptionsBuilder withApplicationVersion(@Nullable String applicationVersion) {
        this.applicationVersion = applicationVersion;
        return this;
    }

    public Map<String, String> build() {
        DriverExecutionProfile config = this.context.getConfig().getDefaultProfile();
        NullAllowingImmutableMap.Builder builder = NullAllowingImmutableMap.builder((int)3);
        String compressionAlgorithm = this.context.getCompressor().algorithm();
        if (compressionAlgorithm != null && !compressionAlgorithm.trim().isEmpty()) {
            builder.put((Object)"COMPRESSION", (Object)compressionAlgorithm.trim());
        }
        builder.put((Object)DRIVER_NAME_KEY, (Object)this.getDriverName()).put((Object)DRIVER_VERSION_KEY, (Object)this.getDriverVersion());
        if (this.clientId == null) {
            this.clientId = Uuids.random();
        }
        builder.put((Object)CLIENT_ID_KEY, (Object)this.clientId.toString());
        if (this.applicationName == null) {
            this.applicationName = config.getString(DseDriverOption.APPLICATION_NAME, null);
        }
        if (this.applicationName != null) {
            builder.put((Object)APPLICATION_NAME_KEY, (Object)this.applicationName);
        }
        if (this.applicationVersion == null) {
            this.applicationVersion = config.getString(DseDriverOption.APPLICATION_VERSION, null);
        }
        if (this.applicationVersion != null) {
            builder.put((Object)APPLICATION_VERSION_KEY, (Object)this.applicationVersion);
        }
        this.driverBaggage().ifPresent(s -> builder.put((Object)DRIVER_BAGGAGE, s));
        return builder.build();
    }

    protected String getDriverName() {
        return Session.OSS_DRIVER_COORDINATES.getName();
    }

    protected String getDriverVersion() {
        return Session.OSS_DRIVER_COORDINATES.getVersion().toString();
    }

    private Optional<String> driverBaggage() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<String, LoadBalancingPolicy> entry : this.context.getLoadBalancingPolicies().entrySet()) {
            Map<String, ?> config = entry.getValue().getStartupConfiguration();
            if (config.isEmpty()) continue;
            builder.put((Object)entry.getKey(), config);
        }
        try {
            return Optional.of(mapper.writeValueAsString((Object)builder.build()));
        }
        catch (Exception e) {
            LOG.warn("Failed to construct startup driver baggage", (Throwable)e);
            return Optional.empty();
        }
    }
}

