/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.schema.AlterDseKeyspace;
import com.datastax.dse.driver.api.querybuilder.schema.AlterDseKeyspaceStart;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultAlterDseKeyspace
implements AlterDseKeyspaceStart,
AlterDseKeyspace {
    private final CqlIdentifier keyspaceName;
    private final ImmutableMap<String, Object> options;

    public DefaultAlterDseKeyspace(@NonNull CqlIdentifier keyspaceName) {
        this(keyspaceName, (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    public DefaultAlterDseKeyspace(@NonNull CqlIdentifier keyspaceName, @NonNull ImmutableMap<String, Object> options) {
        this.keyspaceName = keyspaceName;
        this.options = options;
    }

    @Override
    @NonNull
    public AlterDseKeyspace withDurableWrites(boolean durableWrites) {
        return this.withOption("durable_writes", durableWrites);
    }

    @Override
    @NonNull
    public AlterDseKeyspace withGraphEngine(String graphEngine) {
        return this.withOption("graph_engine", graphEngine);
    }

    @Override
    @NonNull
    public AlterDseKeyspace withReplicationOptions(@NonNull Map<String, Object> replicationOptions) {
        return this.withOption("replication", replicationOptions);
    }

    @Override
    @NonNull
    public AlterDseKeyspace withSimpleStrategy(int replicationFactor) {
        ImmutableMap replication = ImmutableMap.builder().put((Object)"class", (Object)"SimpleStrategy").put((Object)"replication_factor", (Object)replicationFactor).build();
        return this.withReplicationOptions((Map)replication);
    }

    @Override
    @NonNull
    public AlterDseKeyspace withNetworkTopologyStrategy(@NonNull Map<String, Integer> replications) {
        ImmutableMap.Builder replicationBuilder = ImmutableMap.builder().put((Object)"class", (Object)"NetworkTopologyStrategy");
        for (Map.Entry<String, Integer> replication : replications.entrySet()) {
            replicationBuilder.put((Object)replication.getKey(), (Object)replication.getValue());
        }
        return this.withReplicationOptions((Map)replicationBuilder.build());
    }

    @Override
    @NonNull
    public AlterDseKeyspace withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultAlterDseKeyspace(this.keyspaceName, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public String asCql() {
        return "ALTER KEYSPACE " + this.keyspaceName.asCql(true) + OptionsUtils.buildOptions(this.options, true);
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspaceName;
    }

    public String toString() {
        return this.asCql();
    }
}

