/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.FullRowReader;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.QueryMetadata;

class InheritanceAwareRowReader
extends FullRowReader {
    private EntityInheritanceTree entityInheritanceTree;

    InheritanceAwareRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata) {
        super(descriptor, queryMetadata);
        this.entityInheritanceTree = queryMetadata.getClassDescriptor().getEntityInheritanceTree();
    }

    void postprocessRow(ResultSet resultSet, DataRow dataRow) throws Exception {
        ObjEntity entity;
        if (this.postProcessor != null) {
            this.postProcessor.postprocessRow(resultSet, dataRow);
        }
        dataRow.setEntityName((entity = this.entityInheritanceTree.entityMatchingRow(dataRow)) != null ? entity.getName() : this.entityName);
    }
}

