/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.rop.client;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.remote.ClientConnection;
import org.apache.cayenne.remote.hessian.HessianConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HessianConnectionProvider
implements Provider<ClientConnection> {
    @Inject
    protected RuntimeProperties runtimeProperties;

    @Override
    public ClientConnection get() throws ConfigurationException {
        String url = this.runtimeProperties.get("cayenne.config.rop.service.url");
        if (url == null) {
            throw new ConfigurationException("No property defined for '%s', can't initialize HessianConnection", "cayenne.config.rop.service.url");
        }
        String userName = this.runtimeProperties.get("cayenne.config.rop.service.username");
        String password = this.runtimeProperties.get("cayenne.config.rop.service.password");
        String sharedSession = this.runtimeProperties.get("cayenne.config.rop.service.shared_session");
        return new HessianConnection(url, userName, password, sharedSession);
    }
}

